/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.uvector;

import java.util.Arrays;
import net.morilib.lang.Hashes;
import net.morilib.util.Arrays2;
import net.morilib.util.Bytes;
import net.morilib.util.uvector.AbstractUniformArray;
import net.morilib.util.uvector.Endianness;
import net.morilib.util.uvector.UniformArray;

public class LongArray
extends AbstractUniformArray {
    private long[] array;
    private UniformArray.TypeAttr signed;

    private LongArray(long[] arr, UniformArray.TypeAttr attr) {
        if (!attr.isExact()) {
            throw new IllegalArgumentException(attr.toString());
        }
        if (arr == null) {
            throw new NullPointerException();
        }
        this.array = new long[arr.length];
        this.signed = attr;
        System.arraycopy(arr, 0, this.array, 0, arr.length);
    }

    public LongArray(LongArray a) {
        this.array = Arrays2.copy(a.array);
        this.signed = a.signed;
    }

    public static LongArray newArray(long[] arr) {
        return new LongArray(arr, UniformArray.TypeAttr.SIGNED_INT);
    }

    public static LongArray newuArray(long[] arr) {
        return new LongArray(arr, UniformArray.TypeAttr.UNSIGNED_INT);
    }

    public static LongArray malloc(int size) {
        return new LongArray(new long[size], UniformArray.TypeAttr.SIGNED_INT);
    }

    public static LongArray mallocu(int size) {
        return new LongArray(new long[size], UniformArray.TypeAttr.UNSIGNED_INT);
    }

    public byte getByte(int i) {
        short r = this.getShort(i);
        return (byte)r;
    }

    public double getDouble(int i) {
        if (this.signed.isSigned()) {
            return this.getLong(i);
        }
        return Bytes.ulongToDouble(this.getLong(i));
    }

    public float getFloat(int i) {
        if (this.signed.isSigned()) {
            return this.getLong(i);
        }
        return Bytes.ulongToFloat(this.getLong(i));
    }

    public int getInt(int i) {
        return (int)this.getLong(i);
    }

    public long getLong(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        return this.array[i];
    }

    public short getShort(int i) {
        return (short)this.getLong(i);
    }

    public void setByte(int i, byte x) {
        this.setLong(i, this.signed.isSigned() ? (long)x : Bytes.ubyteToLong(x));
    }

    public void setDouble(int i, double x) {
        this.setLong(i, this.signed.isSigned() ? (long)x : Bytes.doubleTouLong(x));
    }

    public void setFloat(int i, float x) {
        this.setDouble(i, x);
    }

    public void setInt(int i, int x) {
        this.setLong(i, this.signed.isSigned() ? (long)x : Bytes.uintToLong(x));
    }

    public void setLong(int i, long x) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        this.array[i] = x;
    }

    public void setShort(int i, short x) {
        this.setLong(i, this.signed.isSigned() ? (long)x : Bytes.ushortToLong(x));
    }

    public int size() {
        return this.array.length;
    }

    public byte[] toByteArray(Endianness e) {
        byte[] res = new byte[this.array.length << 3];
        int i = 0;
        while (i < this.array.length) {
            e.writeLong(res, i << 3, this.array[i]);
            ++i;
        }
        return res;
    }

    public long[] toArray() {
        return Arrays2.copy(this.array);
    }

    public int hashCode() {
        return Hashes.sumHashCode(this.array);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongArray) {
            return Arrays.equals(this.array, ((LongArray)obj).array);
        }
        return false;
    }
}

