/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.uvector;

import java.util.Arrays;
import net.morilib.lang.Hashes;
import net.morilib.util.Arrays2;
import net.morilib.util.Bytes;
import net.morilib.util.uvector.AbstractUniformArray;
import net.morilib.util.uvector.ByteMemory;
import net.morilib.util.uvector.Endianness;
import net.morilib.util.uvector.UniformArray;

public class ByteArray
extends AbstractUniformArray
implements ByteMemory {
    private byte[] array;
    private UniformArray.TypeAttr signed;

    private ByteArray(byte[] arr, UniformArray.TypeAttr attr) {
        if (!attr.isExact()) {
            throw new IllegalArgumentException(attr.toString());
        }
        if (arr == null) {
            throw new NullPointerException();
        }
        this.array = Arrays2.copy(arr);
        this.signed = attr;
    }

    public ByteArray(ByteArray a) {
        this.array = Arrays2.copy(a.array);
        this.signed = a.signed;
    }

    public static ByteArray newArray(byte[] arr) {
        return new ByteArray(arr, UniformArray.TypeAttr.SIGNED_INT);
    }

    public static ByteArray newuArray(byte[] arr) {
        return new ByteArray(arr, UniformArray.TypeAttr.UNSIGNED_INT);
    }

    public static ByteArray malloc(int size) {
        return new ByteArray(new byte[size], UniformArray.TypeAttr.SIGNED_INT);
    }

    public static ByteArray mallocu(int size) {
        return new ByteArray(new byte[size], UniformArray.TypeAttr.UNSIGNED_INT);
    }

    public byte getByte(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        return this.array[i];
    }

    public double getDouble(int i) {
        return this.getInt(i);
    }

    public float getFloat(int i) {
        return this.getInt(i);
    }

    public int getInt(int i) {
        int r = this.getByte(i);
        int s = this.signed.isSigned() ? r : Bytes.ubyteToInt((byte)r);
        return s;
    }

    public long getLong(int i) {
        return this.getInt(i);
    }

    public short getShort(int i) {
        return (short)this.getInt(i);
    }

    public void setByte(int i, byte x) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        this.array[i] = x;
    }

    public void setDouble(int i, double x) {
        this.setInt(i, (int)x);
    }

    public void setFloat(int i, float x) {
        this.setDouble(i, x);
    }

    public void setInt(int i, int x) {
        this.setByte(i, (byte)x);
    }

    public void setLong(int i, long x) {
        this.setByte(i, (byte)x);
    }

    public void setShort(int i, short x) {
        this.setByte(i, (byte)x);
    }

    public int size() {
        return this.array.length;
    }

    public byte readByte(int i) {
        return this.getByte(i);
    }

    public double readDouble(int i, Endianness e) {
        return Double.longBitsToDouble(this.readLong(i, e));
    }

    public float readFloat(int i, Endianness e) {
        return Float.intBitsToFloat(this.readInt(i, e));
    }

    public int readInt(int i, Endianness e) {
        return e.readInt(this.array, i);
    }

    public long readLong(int i, Endianness e) {
        return e.readLong(this.array, i);
    }

    public short readShort(int i, Endianness e) {
        return (short)this.readuShort(i, e);
    }

    public void writeByte(int i, byte x) {
        this.setByte(i, x);
    }

    public void writeDouble(int i, double x, Endianness e) {
        this.writeLong(i, Double.doubleToLongBits(x), e);
    }

    public void writeFloat(int i, float x, Endianness e) {
        this.writeInt(i, Float.floatToIntBits(x), e);
    }

    public void writeInt(int i, int x, Endianness e) {
        e.writeInt(this.array, i, x);
    }

    public void writeLong(int i, long x, Endianness e) {
        e.writeLong(this.array, i, x);
    }

    public void writeShort(int i, short x, Endianness e) {
        e.writeShort(this.array, i, x);
    }

    public int readuByte(int i) {
        return Bytes.ubyteToInt(this.readByte(i));
    }

    public long readuInt(int i, Endianness e) {
        return e.readuInt(this.array, i);
    }

    public int readuShort(int i, Endianness e) {
        return e.readuShort(this.array, i);
    }

    public void writeuByte(int i, int x) {
        this.writeByte(i, (byte)x);
    }

    public void writeuInt(int i, long x, Endianness e) {
        e.writeuInt(this.array, i, x);
    }

    public void writeuShort(int i, int x, Endianness e) {
        e.writeuShort(this.array, i, x);
    }

    public double readDoubleB(int i) {
        return this.readDouble(i, Endianness.BIG);
    }

    public double readDoubleL(int i) {
        return this.readDouble(i, Endianness.LITTLE);
    }

    public float readFloatB(int i) {
        return this.readFloat(i, Endianness.BIG);
    }

    public float readFloatL(int i) {
        return this.readFloat(i, Endianness.LITTLE);
    }

    public int readIntB(int i) {
        return this.readInt(i, Endianness.BIG);
    }

    public int readIntL(int i) {
        return this.readInt(i, Endianness.LITTLE);
    }

    public long readLongB(int i) {
        return this.readLong(i, Endianness.BIG);
    }

    public long readLongL(int i) {
        return this.readLong(i, Endianness.LITTLE);
    }

    public short readShortB(int i) {
        return this.readShort(i, Endianness.BIG);
    }

    public short readShortL(int i) {
        return this.readShort(i, Endianness.LITTLE);
    }

    public long readuIntB(int i) {
        return this.readuInt(i, Endianness.BIG);
    }

    public long readuIntL(int i) {
        return this.readuInt(i, Endianness.LITTLE);
    }

    public int readuShortB(int i) {
        return this.readuShort(i, Endianness.BIG);
    }

    public int readuShortL(int i) {
        return this.readuShort(i, Endianness.LITTLE);
    }

    public void writeDoubleB(int i, double x) {
        this.writeDouble(i, x, Endianness.BIG);
    }

    public void writeDoubleL(int i, double x) {
        this.writeDouble(i, x, Endianness.LITTLE);
    }

    public void writeFloatB(int i, float x) {
        this.writeFloat(i, x, Endianness.BIG);
    }

    public void writeFloatL(int i, float x) {
        this.writeFloat(i, x, Endianness.LITTLE);
    }

    public void writeIntB(int i, int x) {
        this.writeInt(i, x, Endianness.BIG);
    }

    public void writeIntL(int i, int x) {
        this.writeInt(i, x, Endianness.LITTLE);
    }

    public void writeLongB(int i, long x) {
        this.writeLong(i, x, Endianness.BIG);
    }

    public void writeLongL(int i, long x) {
        this.writeLong(i, x, Endianness.LITTLE);
    }

    public void writeShortB(int i, short x) {
        this.writeShort(i, x, Endianness.BIG);
    }

    public void writeShortL(int i, short x) {
        this.writeShort(i, x, Endianness.LITTLE);
    }

    public void writeuIntB(int i, long x) {
        this.writeuInt(i, x, Endianness.BIG);
    }

    public void writeuIntL(int i, long x) {
        this.writeuInt(i, x, Endianness.LITTLE);
    }

    public void writeuShortB(int i, int x) {
        this.writeuShort(i, x, Endianness.BIG);
    }

    public void writeuShortL(int i, int x) {
        this.writeuShort(i, x, Endianness.LITTLE);
    }

    public byte[] toByteArray() {
        return Arrays2.copy(this.array);
    }

    public byte[] toByteArray(Endianness e) {
        return this.toByteArray();
    }

    public void arraycopy(int sd, ByteArray s, int ss, int l) {
        System.arraycopy(s.array, ss, this.array, sd, l);
    }

    public int hashCode() {
        return Hashes.sumHashCode(this.array);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteArray) {
            return Arrays.equals(this.array, ((ByteArray)obj).array);
        }
        return false;
    }
}

