/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CascadedIterator<E>
implements Iterator<E> {
    private List<Iterator<E>> iterators = new ArrayList<Iterator<E>>();
    private int ptr = 0;

    public CascadedIterator(Collection<Iterator<E>> cols) {
        for (Iterator<E> i : cols) {
            this.iterators.add(i);
        }
    }

    public CascadedIterator(Iterator<E> iter1, Iterator<E> iter2) {
        this.iterators.add(iter1);
        this.iterators.add(iter2);
    }

    @Override
    public void remove() {
        if (this.ptr >= this.iterators.size()) {
            throw new NoSuchElementException();
        }
        this.iterators.get(this.ptr).remove();
    }

    @Override
    public boolean hasNext() {
        while (this.ptr < this.iterators.size() && !this.iterators.get(this.ptr).hasNext()) {
            ++this.ptr;
        }
        return this.ptr < this.iterators.size();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.iterators.get(this.ptr).next();
    }
}

