/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.io;

import java.io.IOException;
import java.io.OutputStream;

public class UTF8StringBuilderOutputStream
extends OutputStream {
    private int b1;
    private int b2;
    private int stat = 0;
    private StringBuilder buf = new StringBuilder();

    public void write(int b) throws IOException {
        switch (this.stat) {
            case 0: {
                if ((b & 0x80) == 0) {
                    this.buf.append((char)(b & 0x7F));
                    break;
                }
                if ((b & 0xE0) == 192) {
                    this.b1 = b & 0x3F;
                    this.stat = 10;
                    break;
                }
                if ((b & 0xF0) == 224) {
                    this.b1 = b & 0xF;
                    this.stat = 20;
                    break;
                }
                if ((b & 0xF8) != 240) break;
                this.b1 = b & 7;
                this.stat = 30;
                break;
            }
            case 10: {
                int c;
                if ((b & 0xC0) == 128 && (c = this.b1 << 6 | b & 0x3F) >= 128) {
                    this.buf.append((char)c);
                }
                this.stat = 0;
                break;
            }
            case 20: {
                if ((b & 0xC0) == 128) {
                    this.b2 = b & 0x3F;
                    this.stat = 21;
                    break;
                }
                this.stat = 0;
                break;
            }
            case 21: {
                int c;
                if ((b & 0xC0) == 128 && (c = this.b1 << 12 | this.b2 << 6 | b & 0x3F) >= 2048) {
                    this.buf.append((char)c);
                }
                this.stat = 0;
                break;
            }
            case 30: {
                if ((b & 0xC0) == 128) {
                    this.b2 = b & 0x3F;
                    this.stat = 31;
                    break;
                }
                this.stat = 0;
                break;
            }
            case 31: {
                if ((b & 0xC0) == 128) {
                    this.stat = 32;
                    break;
                }
                this.stat = 0;
                break;
            }
            case 32: {
                this.stat = 0;
            }
        }
    }

    public void clear() {
        this.buf = new StringBuilder();
    }

    public String toString() {
        return this.buf.toString();
    }
}

