/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.range;

import java.util.ArrayList;
import java.util.List;
import net.morilib.range.CharSetException;
import net.morilib.range.Interval;
import net.morilib.range.IntervalsInt;
import net.morilib.range.Range;
import net.morilib.range.RangeAdder;
import net.morilib.range.Ranges;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharSets {
    public static final Range NUMBERS = CharSets.newCharInterval('0', '9');
    public static final Range ASCII_NUMBERS = CharSets.newCharInterval('0', '9');
    public static final Range CAPITAL_LETTERS = CharSets.newCharInterval('A', 'Z');
    public static final Range SMALL_LETTERS = CharSets.newCharInterval('a', 'z');
    public static final Range ENGLISH_ALPHABETS = Ranges.sum(CAPITAL_LETTERS, SMALL_LETTERS);
    public static final Range ENGLISH_ALPHABETS_NUMBERS = Ranges.sum(ENGLISH_ALPHABETS, ASCII_NUMBERS);
    public static final Range HIRAGANA = CharSets.newCharInterval('\u3041', '\u3094');
    public static final Range KATAKANA = CharSets.newCharInterval('\u30a1', '\u30fa');
    public static final Range SPACES = Ranges.sum(IntervalsInt.newPoint(32), IntervalsInt.newPoint(9));
    public static final Range TOKEN = Ranges.sum(IntervalsInt.newPoint(32), IntervalsInt.newPoint(9));
    public static final Range ALL_CHAR = IntervalsInt.newRightOpenInterval(0, 65536);

    private CharSets() {
    }

    public static final Range newCharInterval(char f, char t) {
        return IntervalsInt.newRightOpenInterval(f, t + '\u0001');
    }

    public static final Range newCharInterval(char c) {
        return IntervalsInt.newRightOpenInterval(c, c + '\u0001');
    }

    private static Interval getintv(int ch, int ch2) {
        return IntervalsInt.newRightOpenInterval(ch, ch2 + 1);
    }

    static boolean parse(CharSequence s, CharSetHandler h) {
        StringBuilder b = new StringBuilder();
        int st = 1;
        int cb = -1;
        int pt = 0;
        block19: while (pt < s.length()) {
            int cz;
            block35: {
                int c = s.charAt(pt++);
                if (st == 1) {
                    if (c == 92) {
                        st = 2;
                        continue;
                    }
                    cb = c;
                    st = 4;
                    continue;
                }
                if (st == 2) {
                    switch (c) {
                        case 117: 
                        case 120: {
                            st = 3;
                            continue block19;
                        }
                        case 92: {
                            cb = c;
                            st = 4;
                            continue block19;
                        }
                        case 116: {
                            cb = 9;
                            st = 4;
                            continue block19;
                        }
                        case 110: {
                            cb = 10;
                            st = 4;
                            continue block19;
                        }
                        case 114: {
                            cb = 13;
                            st = 4;
                            continue block19;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                if (st == 3) {
                    if (pt + 2 >= s.length()) {
                        return false;
                    }
                    b.append((char)c);
                    b.append(s.charAt(pt++));
                    b.append(s.charAt(pt++));
                    b.append(s.charAt(pt++));
                    try {
                        cb = Integer.parseInt(b.toString(), 16);
                        b.delete(0, b.length());
                        st = 4;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Illegal code");
                    }
                }
                if (st == 4) {
                    if (c == 92) {
                        h.singleChar(cb);
                        st = 2;
                        continue;
                    }
                    if (c == 45) {
                        st = 5;
                        continue;
                    }
                    h.singleChar(cb);
                    cb = c;
                    st = 4;
                    continue;
                }
                if (st == 5) {
                    if (c == 92) {
                        st = 6;
                        continue;
                    }
                    if (c < cb) {
                        return false;
                    }
                    h.rangedChar(cb, c);
                    st = 1;
                    continue;
                }
                if (st == 6) {
                    switch (c) {
                        case 117: 
                        case 120: {
                            st = 7;
                            break;
                        }
                        case 92: {
                            break;
                        }
                        case 116: {
                            c = 9;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    if (c < cb) {
                        return false;
                    }
                    h.rangedChar(cb, c);
                    st = 1;
                    continue;
                }
                if (st != 7) continue;
                if (pt + 2 >= s.length()) {
                    return false;
                }
                b.append((char)c);
                b.append(s.charAt(pt++));
                b.append(s.charAt(pt++));
                b.append(s.charAt(pt++));
                try {
                    cz = Integer.parseInt(b.toString(), 16);
                    if (cz >= cb) break block35;
                    return false;
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Illegal code");
                }
            }
            h.rangedChar(cb, cz);
            b.delete(0, b.length());
            st = 1;
        }
        if (st == 4) {
            h.singleChar(cb);
        }
        return true;
    }

    public static Range parse(CharSequence s) {
        final RangeAdder ra = new RangeAdder();
        boolean r = CharSets.parse(s, new CharSetHandler(){

            public void singleChar(int ch) {
                ra.add(CharSets.getintv(ch, ch));
            }

            public void rangedChar(int cb, int ce) {
                ra.add(CharSets.getintv(cb, ce));
            }
        });
        if (!r) {
            throw new CharSetException();
        }
        return ra.toRange();
    }

    private static List<Interval> parseTr(CharSequence s) {
        final ArrayList<Interval> ra = new ArrayList<Interval>();
        boolean r = CharSets.parse(s, new CharSetHandler(){

            public void singleChar(int ch) {
                ra.add(CharSets.getintv(ch, ch));
            }

            public void rangedChar(int cb, int ce) {
                ra.add(CharSets.getintv(cb, ce));
            }
        });
        if (!r) {
            throw new CharSetException();
        }
        return ra;
    }

    private static int card(Interval r1) {
        return (int)IntervalsInt.cardinality(r1);
    }

    private static int card(List<Interval> r1) {
        int r = 0;
        int i = 0;
        while (i < r1.size()) {
            r += (int)IntervalsInt.cardinality(r1.get(i));
            ++i;
        }
        return r;
    }

    public static String tr(CharSequence s, CharSequence t1, CharSequence t2) {
        StringBuilder b = new StringBuilder();
        List<Interval> r1 = CharSets.parseTr(t1);
        List<Interval> r2 = CharSets.parseTr(t2);
        if (CharSets.card(r1) != CharSets.card(r2)) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < s.length()) {
            block6: {
                int ind = 0;
                char c = s.charAt(i);
                int j = 0;
                while (j < r1.size()) {
                    Interval i1 = r1.get(j);
                    if (i1.contains(c)) {
                        int in2 = 0;
                        int c1 = (int)IntervalsInt.indexOf(i1, c);
                        int k = 0;
                        while (k < r2.size()) {
                            int cd2 = CharSets.card(r2.get(k));
                            if (ind + c1 < in2 + cd2) {
                                b.append((char)IntervalsInt.intAt(r2.get(k), c1));
                                break block6;
                            }
                            in2 += cd2;
                            ++k;
                        }
                        throw new RuntimeException();
                    }
                    ind += CharSets.card(i1);
                    ++j;
                }
                b.append(c);
            }
            ++i;
        }
        return b.toString();
    }

    static interface CharSetHandler {
        public void singleChar(int var1);

        public void rangedChar(int var1, int var2);
    }
}

