/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.util.List;
import javax.swing.JTextField;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.swing.GUIElement;
import net.morilib.lisp.swing.HasText;
import net.morilib.lisp.swing.LispComponent;

public class LispTextField
extends GUIElement
implements LispComponent,
HasText {
    private JTextField field;

    public LispTextField(JTextField f) {
        this.field = f;
    }

    public JTextField getComponent() {
        return this.field;
    }

    public String getText() {
        return this.field.getText();
    }

    public void setText(String s) {
        this.field.setText(s);
    }

    public Component getAWTComponent() {
        return this.getComponent();
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<text-field>");
    }

    public static class MakeTextField
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> l = LispUtils.consToList(body, mesg);
            String text = null;
            if (l.size() < 1 || l.size() > 2) {
                throw mesg.getError("err.argument", body);
            }
            if (!(l.get(0) instanceof LispSmallInt)) {
                throw mesg.getError("err.require.smallint", l.get(0));
            }
            int size = l.get(0).getInt();
            if (l.size() == 2) {
                if (l.get(1) instanceof LispString) {
                    text = l.get(1).getString();
                } else {
                    throw mesg.getError("err.require.string", l.get(1));
                }
            }
            JTextField f = text == null ? new JTextField(size) : new JTextField(text, size);
            return new LispTextField(f);
        }
    }
}

