/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.util.List;
import javax.swing.JFrame;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.swing.GUIElement;
import net.morilib.lisp.swing.ILispWindow;
import net.morilib.lisp.swing.LispComposite;
import net.morilib.lisp.swing.LispMenuBar;

public class LispFrame
extends GUIElement
implements LispComposite,
ILispWindow {
    private JFrame window;

    public LispFrame(JFrame window) {
        this.window = window;
    }

    public Container getPane() {
        return this.window.getContentPane();
    }

    public JFrame getFrame() {
        return this.window;
    }

    public Component getAWTComponent() {
        return this.window;
    }

    public void addWindowListener(WindowListener l) {
        this.window.addWindowListener(l);
    }

    public Window getAWTWindow() {
        return this.window;
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<window>");
    }

    public static class ExecWindow
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispFrame) {
                ((LispFrame)c1a).window.setDefaultCloseOperation(3);
                ((LispFrame)c1a).window.setVisible(true);
                return Undef.UNDEF;
            }
            throw mesg.getError("err.swing.require.window", c1a);
        }
    }

    public static class MakeWindow
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> l = LispUtils.consToList(body, mesg);
            if (l.size() == 1) {
                String t = SubrUtils.getString(l.get(0), mesg);
                JFrame w = new JFrame(t);
                return new LispFrame(w);
            }
            if (l.size() == 3) {
                String t = SubrUtils.getString(l.get(0), mesg);
                int x = SubrUtils.getSmallIntegerExact(l.get(1), mesg);
                int y = SubrUtils.getSmallIntegerExact(l.get(2), mesg);
                JFrame w = new JFrame(t);
                w.setSize(x, y);
                return new LispFrame(w);
            }
            if (l.size() == 4) {
                String t = SubrUtils.getString(l.get(0), mesg);
                int x = SubrUtils.getSmallIntegerExact(l.get(1), mesg);
                int y = SubrUtils.getSmallIntegerExact(l.get(2), mesg);
                JFrame w = new JFrame(t);
                w.setSize(x, y);
                w.setJMenuBar(LispMenuBar.parseMenuBar(l.get(3), env, mesg));
                return new LispFrame(w);
            }
            throw mesg.getError("err.argument", body);
        }
    }
}

