/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMath;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.lib.srfi094.SRFI94;
import net.morilib.lisp.subr.BinaryArgs;

public class Quotient
extends BinaryArgs {
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispReal && c2a instanceof LispReal) {
            LispReal r1 = (LispReal)c1a;
            LispReal r2 = (LispReal)c2a;
            if (r2.signum() == 0) {
                throw mesg.getError("err.divbyzero");
            }
            if (r1.isInteger() && r2.isInteger()) {
                BigInteger a = r1.getBigInteger();
                BigInteger b = r2.getBigInteger();
                if (r1.isExact() && r2.isExact()) {
                    return LispInteger.valueOf(a.divide(b));
                }
                if (SRFI94.isSafe(env)) {
                    throw mesg.getError("err.srfi94.outofdomain");
                }
                return new LispDouble(a.divide(b).doubleValue());
            }
            if (!(SRFI94.isSafe(env) || r1.isInfinity() || r1.isNaN() || r2.isInfinity() || r2.isNaN())) {
                return LispMath.quo(r1, r2);
            }
            if (!r1.isInteger()) {
                throw mesg.getError("err.srfi94.outofdomain", r1);
            }
            throw mesg.getError("err.srfi94.outofdomain", r2);
        }
        if (!(c1a instanceof LispReal)) {
            throw mesg.getError("err.require.real", c1a);
        }
        throw mesg.getError("err.require.real", c2a);
    }
}

