/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Parser;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.sql.LispSQLUtils;
import net.morilib.lisp.subr.UnaryArgs;

public class JdbcUseDb
extends UnaryArgs {
    private static Map<Datum, Datum> drivers;

    static {
        List<Datum> l;
        InputStream ins = null;
        try {
            try {
                ins = JdbcUseDb.class.getResourceAsStream("dbconfig.s");
                l = Parser.readSExpression(new InputStreamReader(ins, "UTF-8"));
                drivers = LispUtils.assocToMap(l.get(0));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        for (Map.Entry<Datum, Datum> e : LispUtils.assocToMap(l.get(1)).entrySet()) {
            if (!e.getValue().isTrue()) continue;
            try {
                Class<?> cl = Class.forName(e.getValue().getString());
                Constructor<?> cn = cl.getConstructor(String.class);
                cn.newInstance(((Symbol)e.getKey()).getName());
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e1);
            }
            catch (NoSuchMethodException e1) {
                throw new RuntimeException(e1);
            }
            catch (IllegalArgumentException e1) {
                throw new RuntimeException(e1);
            }
            catch (InstantiationException e1) {
                throw new RuntimeException(e1);
            }
            catch (IllegalAccessException e1) {
                throw new RuntimeException(e1);
            }
            catch (InvocationTargetException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    void setDriver(Datum sym, Datum drv) {
        drivers.put(sym, drv);
    }

    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        if (c1a instanceof Symbol) {
            Datum r = drivers.get(c1a);
            if (r == null) {
                throw mesg.getError("err.jdbc.dbnotfound", c1a);
            }
            if (r.isTrue()) {
                try {
                    Class.forName(r.getString());
                }
                catch (ClassNotFoundException e) {
                    throw mesg.getError("err.jdbc.drivernotfound", c1a);
                }
            }
            LispSQLUtils.setSQLUtils(((Symbol)c1a).getName());
            return Undef.UNDEF;
        }
        throw mesg.getError("err.require.symbol", c1a);
    }
}

