/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import net.morilib.lisp.sos.LispTypeException;
import net.morilib.util.Tuple2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LispType {
    private static final LinkedHashSet<LispType> _EMPTY = new LinkedHashSet();
    public static final LispType TOP = new LispType(false);
    public static final LispType COLLECTION;
    public static final LispType SEQUENCE;
    public static final LispType VECTOR;
    public static final LispType LIST;
    public static final LispType STRING;
    public static final LispType NULL;
    public static final LispType PAIR;
    public static final LispType CHAR;
    public static final LispType NUMBER;
    public static final LispType COMPLEX;
    public static final LispType REAL;
    public static final LispType RATIONAL;
    public static final LispType INTEGER;
    public static final LispType BOOLEAN;
    public static final LispType SYMBOL;
    public static final LispType OBJECT;
    public static final LispType CLASS;
    public static final LispType GENERIC;
    public static final LispType KEYWORD;
    public static final LispType REGEXP;
    private List<LispType> supers;
    private transient List<LispType> cpl;

    static {
        try {
            COLLECTION = new LispType(TOP);
            SEQUENCE = new LispType(COLLECTION);
            VECTOR = new LispType(SEQUENCE);
            LIST = new LispType(SEQUENCE);
            STRING = new LispType(SEQUENCE);
            NULL = new LispType(LIST);
            PAIR = new LispType(LIST);
            CHAR = new LispType(TOP);
            NUMBER = new LispType(TOP);
            COMPLEX = new LispType(NUMBER);
            REAL = new LispType(COMPLEX);
            RATIONAL = new LispType(REAL);
            INTEGER = new LispType(RATIONAL);
            BOOLEAN = new LispType(TOP);
            SYMBOL = new LispType(TOP);
            OBJECT = new LispType(TOP);
            CLASS = new LispType(OBJECT);
            GENERIC = new LispType(OBJECT);
            KEYWORD = new LispType(TOP);
            REGEXP = new LispType(TOP);
        }
        catch (LispTypeException e) {
            throw new RuntimeException(e);
        }
    }

    private LispType(boolean x) {
        this.supers = null;
        this.cpl = Collections.singletonList(this);
    }

    LispType(List<LispType> directSuper) throws LispTypeException {
        this.initSupers(directSuper);
        this.computeCPL();
    }

    LispType(List<LispType> directSuper, LispType def) throws LispTypeException {
        this.initSupers(directSuper);
        this.supers.add(def);
        this.computeCPL();
    }

    LispType(LispType ... directSuper) throws LispTypeException {
        if (directSuper == null) {
            throw new NullPointerException();
        }
        if (directSuper.length < 1) {
            throw new IllegalArgumentException();
        }
        this.supers = Arrays.asList(directSuper);
        this.computeCPL();
    }

    private void initSupers(List<LispType> directSuper) {
        if (directSuper == null) {
            throw new NullPointerException();
        }
        if (directSuper.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.supers = new ArrayList<LispType>(directSuper);
    }

    private LinkedHashSet<LispType> computeS() throws LispTypeException {
        if (this.supers == null) {
            return _EMPTY;
        }
        LinkedList<LispType> q = new LinkedList<LispType>(this.supers);
        LinkedHashSet<LispType> res = new LinkedHashSet<LispType>();
        LinkedHashSet<LispType> dne = new LinkedHashSet<LispType>();
        res.add(this);
        res.addAll(this.supers);
        while (!q.isEmpty()) {
            LispType e = q.remove(0);
            if (dne.contains(e)) continue;
            if (e.supers != null) {
                LinkedHashSet<LispType> s = new LinkedHashSet<LispType>(e.supers);
                res.addAll(s);
                q.addAll(s);
            }
            dne.add(e);
        }
        return res;
    }

    private LinkedHashSet<Tuple2<LispType, LispType>> getRSet() {
        LinkedHashSet<Tuple2<LispType, LispType>> res = new LinkedHashSet<Tuple2<LispType, LispType>>();
        if (this.supers == null) {
            return null;
        }
        res.add(new Tuple2<LispType, LispType>(this, this.supers.get(0)));
        int i = 1;
        while (i < this.supers.size()) {
            res.add(new Tuple2<LispType, LispType>(this.supers.get(i - 1), this.supers.get(i)));
            ++i;
        }
        return res;
    }

    private boolean isPrecedent(LispType e, LinkedHashSet<Tuple2<LispType, LispType>> r) {
        for (Tuple2 tuple2 : r) {
            if (!e.equals(tuple2.getB())) continue;
            return true;
        }
        return false;
    }

    private LispType nextE(Collection<LispType> s, LinkedHashSet<Tuple2<LispType, LispType>> r, List<LispType> l) throws LispTypeException {
        if (l.size() > 0) {
            ArrayList<LispType> mb = new ArrayList<LispType>();
            for (LispType e : s) {
                if (this.isPrecedent(e, r)) continue;
                mb.add(e);
            }
            if (mb.isEmpty()) {
                throw new LispTypeException();
            }
            int i = 0;
            while (i < l.size()) {
                int j = 0;
                while (j < mb.size()) {
                    int x = l.get(i).getSuperIndex((LispType)mb.get(j));
                    if (x >= 0) {
                        return (LispType)mb.get(j);
                    }
                    ++j;
                }
                ++i;
            }
            throw new LispTypeException();
        }
        Iterator<LispType> i = s.iterator();
        return i.next();
    }

    private void removeR(LinkedHashSet<Tuple2<LispType, LispType>> r, LispType n) {
        Iterator i = r.iterator();
        while (i.hasNext()) {
            Tuple2 e = (Tuple2)i.next();
            if (!n.equals(e.getA())) continue;
            i.remove();
        }
    }

    private void computeCPL() throws LispTypeException {
        LinkedHashSet<LispType> s = this.computeS();
        LinkedHashSet<Tuple2<LispType, LispType>> r = new LinkedHashSet<Tuple2<LispType, LispType>>();
        ArrayList<LispType> res = new ArrayList<LispType>();
        for (LispType e : s) {
            LinkedHashSet<Tuple2<LispType, LispType>> x = e.getRSet();
            if (x == null) continue;
            r.addAll(x);
        }
        while (!s.isEmpty()) {
            LispType n = this.nextE(s, r, res);
            s.remove(n);
            this.removeR(r, n);
            res.add(n);
        }
        this.cpl = res;
    }

    public int getSuperIndex(LispType e) {
        return this.supers.indexOf(e);
    }

    public List<LispType> getSupers() {
        return Collections.unmodifiableList(this.supers);
    }

    public List<LispType> getCPL() {
        return Collections.unmodifiableList(this.cpl);
    }

    public boolean contains(LispType t) {
        return this.cpl.contains(t);
    }
}

