/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter;

import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.painter.SchlushColor;

public class MakeColor
extends Subr {
    private void checkRange(double x, LispMessage mesg) {
        if (x < 0.0 || x > 1.0) {
            throw mesg.getError("err.range.0to1", Double.toString(x));
        }
    }

    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> l = LispUtils.consToList(body, mesg);
        if (l.size() == 3) {
            LispUtils.checkReal(l.get(0), mesg);
            LispUtils.checkReal(l.get(1), mesg);
            LispUtils.checkReal(l.get(2), mesg);
        } else if (l.size() == 4) {
            LispUtils.checkReal(l.get(0), mesg);
            LispUtils.checkReal(l.get(1), mesg);
            LispUtils.checkReal(l.get(2), mesg);
            LispUtils.checkReal(l.get(3), mesg);
        } else {
            throw mesg.getError("err.argument", body);
        }
        double r = l.get(0).getRealDouble();
        double g = l.get(1).getRealDouble();
        double b = l.get(2).getRealDouble();
        this.checkRange(r, mesg);
        this.checkRange(g, mesg);
        this.checkRange(b, mesg);
        if (l.size() == 3) {
            return new SchlushColor(r, g, b);
        }
        double a = l.get(3).getRealDouble();
        this.checkRange(a, mesg);
        return new SchlushColor(r, g, b, a);
    }
}

