/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface LispEnumeration
extends Iterable<Datum> {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerationFoldLeft
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public EnumerationFoldLeft(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum c2a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum c3a = itr.rest();
            this.checkType(c1a, mesg);
            if (!(c1a instanceof LispEnumeration)) {
                throw mesg.getError("err.srfi44.require.enumeration", c1a);
            }
            Datum[] r = LispUtils.toArray(c3a, mesg);
            for (Datum d : (LispEnumeration)((Object)c1a)) {
                int i = 0;
                while (i < r.length) {
                    r[i] = Scheme.callva(c2a, env, mesg, d, r[i]);
                    ++i;
                }
            }
            return MultiValues.newValues(r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerationFoldRight
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public EnumerationFoldRight(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum c2a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum c3a = itr.rest();
            this.checkType(c1a, mesg);
            if (!(c1a instanceof LispEnumeration)) {
                throw mesg.getError("err.srfi44.require.enumeration", c1a);
            }
            Datum[] r = LispUtils.toArray(c3a, mesg);
            List l = Iterators.toList(((LispEnumeration)((Object)c1a)).iterator());
            ListIterator i2 = l.listIterator(l.size());
            while (i2.hasPrevious()) {
                Datum x = (Datum)i2.previous();
                int i = 0;
                while (i < r.length) {
                    r[i] = Scheme.callva(c2a, env, mesg, x, r[i]);
                    ++i;
                }
            }
            return MultiValues.newValues(r);
        }
    }

    public static class IsEnumeration
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispEnumeration);
        }
    }
}

