/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Subr;
import net.morilib.lisp.array.LispArray;
import net.morilib.lisp.array.LispSharedArray;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.primitive.IntegerArrayVector;

public class MakeSharedArray
extends Subr {
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum pr = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        IntegerArrayVector bin = new IntegerArrayVector();
        while (itr.hasNext()) {
            int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
            if (b < 0) {
                throw mesg.getError("err.srfi25.arraysize.invalid", LispInteger.valueOf(b));
            }
            bin.add(b);
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        if (!(a instanceof LispArray)) {
            throw mesg.getError("err.srfi25.require.array", a);
        }
        if (!(pr instanceof Procedure)) {
            throw mesg.getError("err.require.procedure", pr);
        }
        return new LispSharedArray((LispArray)((Object)a), bin.toIntArray(), (Procedure)((Object)pr), env, mesg);
    }
}

