/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.util.Arrays;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Subr;
import net.morilib.lisp.array.LispArray;
import net.morilib.lisp.array.LispArrayPrototype;
import net.morilib.lisp.array.LispArrayShape;
import net.morilib.lisp.array.LispDefaultArray;
import net.morilib.lisp.array.SRFI47Array;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LispArrayR64
extends SRFI47Array {
    private double[] real;

    public LispArrayR64(double r, int ... is) {
        super(is);
        this.real = new double[LispArrayShape.arraylength(is)];
        Arrays.fill(this.real, r);
    }

    @Override
    public int rank() {
        return this.eIndices.length;
    }

    @Override
    public int startIndex(int dim) {
        if (dim < 0 || dim >= this.eIndices.length) {
            throw new IndexOutOfBoundsException();
        }
        return 0;
    }

    @Override
    public int endIndex(int dim) {
        return this.eIndices[dim];
    }

    @Override
    public LispVector toVector() {
        Datum[] r = new Datum[LispArrayShape.arraylength(this.eIndices)];
        int i = 0;
        while (i < r.length) {
            r[i] = new LispDouble(this.real[i]);
            ++i;
        }
        return new LispVector(r);
    }

    @Override
    public Datum getFromArray(int ... is) {
        return new LispDouble(this.real[LispArrayShape.arrayindex(this.eIndices, is)]);
    }

    @Override
    public void setToArray(Datum d, int ... is) {
        if (!(d instanceof LispReal)) {
            throw new ClassCastException();
        }
        this.real[LispArrayShape.arrayindex((int[])this.eIndices, (int[])is)] = d.getRealDouble();
    }

    @Override
    public boolean isEqualTo(LispArray a) {
        if (!this.isIndexEqualTo(a)) {
            return false;
        }
        if (a instanceof LispArrayR64) {
            return Arrays.equals(this.real, ((LispArrayR64)a).real);
        }
        return LispDefaultArray.isEqualTo(this, a);
    }

    @Override
    public String getTypeSpecifier() {
        return "floR64b";
    }

    @Override
    public void fill(Iterator<Datum> itr) {
        int i = 0;
        while (i < this.real.length && itr.hasNext()) {
            Datum x = itr.next();
            if (!(x instanceof LispReal)) {
                throw new ClassCastException();
            }
            this.real[i] = x.getRealDouble();
            ++i;
        }
    }

    public static class Ar64
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = Iterators.nextIf(itr);
            SubrUtils.checkTerminated(itr, body, mesg);
            if (d == null || d instanceof LispReal) {
                return new Prototype(d == null ? 0.0 : d.getRealDouble());
            }
            throw mesg.getError("err.require.real", d);
        }
    }

    public static class Prototype
    extends Datum2
    implements LispArrayPrototype {
        private double real;

        public Prototype(double real) {
            this.real = real;
        }

        public LispArray makeArray(int ... is) {
            return new LispArrayR64(this.real, is);
        }

        public void toDisplayString(StringBuilder buf) {
            buf.append("#<ar64 prototype>");
        }
    }
}

