/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.HashMap;
import java.util.Map;
import net.morilib.lisp.Atom;
import net.morilib.lisp.LispString;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.sos.LispType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Symbol
extends Atom
implements SymbolName {
    static final Namespace DEFAULT_NAMESPACE = new Namespace();
    public static final Symbol QUOTE = DEFAULT_NAMESPACE.getSymbol("quote");
    public static final Symbol QUASIQUOTE = DEFAULT_NAMESPACE.getSymbol("quasiquote");
    public static final Symbol UNQUOTE = DEFAULT_NAMESPACE.getSymbol("unquote");
    public static final Symbol UNQUOTE_SPLICING = DEFAULT_NAMESPACE.getSymbol("unquote-splicing");
    private static Namespace namespace = DEFAULT_NAMESPACE;
    private String name;
    private Symbol replace = null;
    private boolean replaced = false;
    private Symbol macroSymbol = null;

    private Symbol(String name) {
        this.name = name;
    }

    public static Symbol getSymbol(String name) {
        return namespace.getSymbol(name);
    }

    static Symbol newAndMark(Map<Symbol, Symbol> box, Symbol sym, boolean mark) {
        Symbol res;
        if (sym == null) {
            throw new NullPointerException();
        }
        if (mark) {
            res = box.get(sym);
            if (res == null) {
                res = new Symbol(null);
                res.replace = sym;
                res.replaced = true;
                res.macroSymbol = sym;
                box.put(sym, res);
            }
        } else if (!sym.replaced) {
            res = sym;
        } else {
            res = sym.replace;
            if (res == null) {
                throw new NullPointerException();
            }
        }
        return res;
    }

    public static Symbol gensym() {
        Symbol res = new Symbol(null);
        return res;
    }

    public static Symbol encloseSymbol(Symbol sym) {
        Symbol res = new Symbol(null);
        res.macroSymbol = sym.macroSymbol;
        return res;
    }

    public boolean isEqv(Atom a) {
        return this.equals(a);
    }

    @Override
    public String getName() {
        return this.name == null ? "#:" + this.hashCode() : this.name;
    }

    public boolean isGenerated() {
        return this.name == null;
    }

    public boolean isReplaced() {
        return this.replace != null;
    }

    @Override
    public LispString toLispString() {
        return new LispString(this.getName());
    }

    @Override
    public String print() {
        return this.getName();
    }

    @Override
    public String getResult() {
        return this.getName();
    }

    Symbol getEnclosedSymbol() {
        Symbol sym = this;
        while (sym.macroSymbol != null) {
            sym = sym.macroSymbol;
        }
        return sym;
    }

    @Override
    public String toString() {
        return "Symbol:" + this.getName() + ":" + System.identityHashCode(this);
    }

    @Override
    public boolean isTypeSymbol() {
        return true;
    }

    @Override
    public Symbol getSymbol() {
        return this;
    }

    @Override
    public LispType getType() {
        return LispType.SYMBOL;
    }

    /* synthetic */ Symbol(String string, Symbol symbol) {
        this(string);
    }

    static class Namespace {
        private Map<String, Symbol> flyweight = new HashMap<String, Symbol>();

        Namespace() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Symbol getSymbol(String name) {
            Symbol res;
            if (name == null) {
                throw new NullPointerException("Symbol");
            }
            Namespace namespace = this;
            synchronized (namespace) {
                res = this.flyweight.get(name);
                if (res == null) {
                    res = new Symbol(name, null);
                    this.flyweight.put(name, res);
                }
            }
            return res;
        }
    }
}

