/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.EOFObject;
import net.morilib.lisp.IntLispUtils;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispIOException;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Parser;
import net.morilib.util.io.CharUnreadBuffer;
import net.morilib.util.tape.CharTape;

public class InputPort
extends Datum
implements CharTape,
CharUnreadBuffer {
    private Reader reader;
    private boolean standard;
    private Parser parser;
    private boolean reachedEOF = false;
    private boolean closed = false;
    private LispMessage msg;
    private int unreadbuf = -1;

    private InputPort(Reader rd, boolean std, LispMessage msg) {
        this.reader = rd;
        this.standard = std;
        this.msg = msg;
        this.parser = new Parser(this, msg);
    }

    public InputPort(Reader rd, LispMessage msg) {
        this(rd, false, msg);
    }

    public InputPort(File fname, LispMessage msg) {
        try {
            InputStreamReader rd = new InputStreamReader(new FileInputStream(fname));
            this.reader = new PushbackReader(rd);
            this.standard = false;
            this.msg = msg;
            this.parser = new Parser(this, msg);
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    public InputPort(String fname, String enconding, LispMessage msg) throws UnsupportedEncodingException {
        try {
            InputStreamReader rd = new InputStreamReader((InputStream)new FileInputStream(fname), enconding);
            this.reader = new PushbackReader(rd);
            this.standard = false;
            this.msg = msg;
            this.parser = new Parser(this, msg);
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    static InputPort getStandard(LispMessage msg) {
        return new InputPort(new InputStreamReader(System.in), true, msg);
    }

    public int getc() throws IOException {
        int ch;
        if (this.unreadbuf == -1) {
            ch = this.reader.read();
        } else {
            ch = this.unreadbuf;
            this.unreadbuf = -1;
        }
        return ch;
    }

    public Datum readChar() {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.reachedEOF) {
            return EOFObject.EOF;
        }
        try {
            int ch = this.getc();
            if (ch < 0) {
                this.reachedEOF = true;
                return EOFObject.EOF;
            }
            return new LispCharacter((char)ch);
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    public Datum peekChar() {
        int c = this.readc();
        return c != -1 ? new LispCharacter((char)c) : EOFObject.EOF;
    }

    public Datum readS() {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.reachedEOF) {
            return EOFObject.EOF;
        }
        try {
            this.parser.clear();
            if (this.parser.parse()) {
                Datum res = this.parser.getDatum();
                if (res != null) {
                    return res;
                }
                this.reachedEOF = true;
                return EOFObject.EOF;
            }
            this.reachedEOF = true;
            if (!this.parser.isReadBefore()) {
                return EOFObject.EOF;
            }
            throw this.msg.getReadError("err.read.eof");
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    public void close() {
        try {
            if (!this.closed && !this.standard) {
                this.reader.close();
                this.closed = true;
            }
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    void skipShebang() {
        try {
            this.reachedEOF = !IntLispUtils.skipShebang(this.reader, this);
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    public boolean isStandard() {
        return this.standard;
    }

    public boolean isReachedEOF() {
        return this.reachedEOF;
    }

    public Reader getReader() {
        return this.reader;
    }

    public boolean isTypePort() {
        return true;
    }

    Parser getParser() {
        return this.parser;
    }

    public Integer read() {
        return this.readc();
    }

    public boolean write(Integer symbol) {
        throw new UnsupportedOperationException();
    }

    public boolean moveRight() {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.reachedEOF) {
            return false;
        }
        try {
            int ch = this.getc();
            if (ch < 0) {
                this.reachedEOF = true;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    public boolean moveLeft() {
        return false;
    }

    public int readc() {
        int ch;
        block5: {
            if (this.closed) {
                throw this.msg.getError("err.port.closed");
            }
            if (this.reachedEOF) {
                return -1;
            }
            try {
                ch = this.getc();
                if (ch >= 0) break block5;
                this.reachedEOF = true;
                return -1;
            }
            catch (IOException e) {
                throw new LispIOException(e);
            }
        }
        this.unread((char)ch);
        return ch;
    }

    public boolean writec(int c) {
        throw new UnsupportedOperationException();
    }

    public int mark() {
        throw new UnsupportedOperationException();
    }

    public int back() {
        throw new UnsupportedOperationException();
    }

    public void unread(char c) {
        this.unreadbuf = c;
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<iport>");
    }
}

