/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.grammar.lr;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.grammar.lr.ContextFreeGrammar;
import net.morilib.grammar.lr.ContextFreeRule;
import net.morilib.grammar.lr.GrammarSymbol;
import net.morilib.grammar.lr.Nonterminal;
import net.morilib.lang.Hashes;
import net.morilib.util.LinkedListStack;
import net.morilib.util.Objects;
import net.morilib.util.StateGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LR0Items {
    private ContextFreeGrammar grammar;
    private StateGraph<Set<Item>, GrammarSymbol> goTo = new StateGraph();
    private Set<Item> initialItems;
    private Item initialItem;

    LR0Items(ContextFreeGrammar grammar) {
        this.grammar = grammar;
    }

    public static LR0Items build(ContextFreeGrammar grammar) {
        LR0Items res = new LR0Items(grammar);
        res.computeGoTo();
        return res;
    }

    public ContextFreeGrammar getGrammar() {
        return this.grammar;
    }

    static Map<GrammarSymbol, Set<Item>> extractGoToState(Set<Item> items) {
        HashMap<GrammarSymbol, Set<Item>> res = new HashMap<GrammarSymbol, Set<Item>>();
        for (Item itm : items) {
            if (itm.isReduceState()) continue;
            HashSet<Item> s = (HashSet<Item>)res.get(itm.getDirectedSymbol());
            if (s == null) {
                s = new HashSet<Item>();
                res.put(itm.getDirectedSymbol(), s);
            }
            s.add(itm.shift());
        }
        return res;
    }

    void computeGoTo() {
        LinkedListStack<Set<Item>> stk = new LinkedListStack<Set<Item>>();
        this.initialItem = new Item(this.grammar.getAugmentRule());
        this.initialItems = this.computeItemClosure(Collections.singleton(this.initialItem));
        stk.push(this.initialItems);
        do {
            Set state = (Set)stk.pop();
            Map<GrammarSymbol, Set<Item>> res = LR0Items.extractGoToState(state);
            for (Map.Entry<GrammarSymbol, Set<Item>> e : res.entrySet()) {
                Set<Item> nval = this.computeItemClosure(e.getValue());
                if (!this.goTo.isState(nval)) {
                    stk.push(nval);
                }
                e.setValue(nval);
            }
            this.goTo.addEdgeMap(state, res);
        } while (!stk.isEmpty());
    }

    StateGraph<Set<Item>, GrammarSymbol> getGoToMap() {
        return StateGraph.unmodifiableGraph(this.goTo);
    }

    Set<Item> computeItemClosure(Set<Item> items) {
        LinkedListStack<Item> stk = new LinkedListStack<Item>(items);
        HashSet<Item> res = new HashSet<Item>(items);
        do {
            Item itm;
            if ((itm = (Item)stk.pop()).isReduceState() || !(itm.getDirectedSymbol() instanceof Nonterminal)) continue;
            Set<ContextFreeRule> rules = this.grammar.findRules((Nonterminal)itm.getDirectedSymbol());
            for (ContextFreeRule r : rules) {
                Item i2 = new Item(r);
                if (res.contains(i2)) continue;
                res.add(i2);
                stk.push(i2);
            }
        } while (!stk.isEmpty());
        return res;
    }

    public Set<Item> goTo(Set<Item> state, GrammarSymbol symbol) {
        if (state == null) {
            throw new NullPointerException("state is null");
        }
        return Collections.unmodifiableSet(this.goTo.get(state, symbol));
    }

    public boolean isInitialState(Set<Item> state) {
        return state.contains(this.initialItem);
    }

    public Set<Item> getInitialState() {
        return Collections.unmodifiableSet(this.initialItems);
    }

    public boolean isInitialItem(Item item) {
        return this.initialItem.equals(item);
    }

    Collection<Set<Item>> getAllStates() {
        return Collections.unmodifiableCollection(this.goTo.getAllNodes());
    }

    public boolean isKernel(Item item) {
        return item.itemId > 0 || this.grammar.isAugmentSymbol(item.rule.getLeftSymbol());
    }

    public int getStateSize() {
        return this.goTo.stateSize();
    }

    public static final class Item {
        private ContextFreeRule rule;
        private int itemId = 0;

        Item(ContextFreeRule rule) {
            if (rule == null) {
                throw new NullPointerException();
            }
            this.rule = rule;
        }

        Item(ContextFreeRule rule, int itemId) {
            this(rule);
            this.itemId = itemId;
        }

        int getItemId() {
            return this.itemId;
        }

        public GrammarSymbol getDirectedSymbol() {
            return this.rule.getDerivedSymbol(this.itemId);
        }

        public boolean isReduceState() {
            return this.itemId == this.rule.getDerivedSymbolLength();
        }

        public Item shift() {
            if (!this.isReduceState()) {
                return new Item(this.rule, this.itemId + 1);
            }
            throw new IllegalStateException();
        }

        public ContextFreeRule getRule() {
            return this.rule;
        }

        public boolean equals(Object o) {
            if (o instanceof Item) {
                Item item = (Item)o;
                return Objects.equals(this.rule, item.rule) && this.itemId == item.itemId;
            }
            return false;
        }

        public int hashCode() {
            int r = 17;
            r += 37 * (Hashes.hashCode(this.rule) + r);
            r += 37 * (Hashes.hashCode(this.itemId) + r);
            return r;
        }

        public String toString() {
            List<GrammarSymbol> derived = this.rule.getDerivedSymbols();
            StringBuffer buf = new StringBuffer();
            buf.append(Objects.toString(this.rule.getLeftSymbol()));
            buf.append(" -> ");
            int i = 0;
            while (i < derived.size()) {
                if (i == this.itemId) {
                    buf.append("*");
                }
                buf.append(derived.get(i));
                buf.append(" ");
                ++i;
            }
            return buf.toString();
        }
    }
}

