package Scheduler::Sche::Time;

use strict;
use warnings;
use Carp;

use Time::Local;
use Date::Calc qw|Today_and_Now check_date check_time|;
use Scheduler::Sche::Time::Optimized;

sub new{
  shift;
  return bless {
		begin => undef,
		end => undef,
	       };
}

sub setBegin{
  $_[0]->{begin}=$_[1];
  if(!defined $_[1]){
    $_[0]->{begin} = new Scheduler::Sche::Time::Optimized();
  }
}
sub setEnd{
  $_[0]->{end}=$_[1];
  if(!defined $_[1]){
    $_[0]->{end} = new Scheduler::Sche::Time::Optimized();
  }
}

sub begin{$_[0]->{begin};}
sub end{$_[0]->{end};}

# These subroutines are needed because subroutines setBegin and setEnd cannot make null times.
sub killBegin{$_[0]->{begin} = undef};
sub killEnd{$_[0]->{end} = undef};

sub now{
    shift;
    return time;
}
sub iso8601($$$$$$){
  shift;
  my ($y,$m,$d,$h,$mi,$s) = @_;
}
sub nowStatus{
    my $oS = shift;
    if(!defined $oS->begin and !defined $oS->end){
	return 'halt';
    }else{
	my ($nB,$nE,$nN) = ($oS->begin,
			    $oS->end,
			    $oS->now,
			    );
	foreach($nB,$nE){
	  $_ = $_->time if defined;
	}
	my $sR;
	if(defined $nB && $nB > $nN){
	    $sR = 'coming';
	}elsif(defined $nE && $nE < $nN){
	    $sR = 'done';
	}else{
	    $sR = 'progress';
	}
	return $sR;
    }
}
sub clone{
  my $oS = shift;
  my $oSNew = new Scheduler::Sche::Time;
  $oSNew->setBegin($oS->begin);
  $oSNew->setEnd($oS->end);
  return $oSNew;
}

1;
