package Scheduler::Sche;

use strict;
use warnings;
use Carp;

use Scheduler::Sche::Changeable;
use Scheduler::Sche::Location;

sub new(%){
  shift;
  return bless {
		id => undef,
		uris => [],
		changeables => [],
		generator => undef,
	       };
}
sub id{
  my $oS = shift;
  return defined $oS->{id}?$oS->{id}:"";
}
sub uris{$_[0]->{uris};}
sub changeables{$_[0]->{changeables};}
sub generator{$_[0]->{generator};}

sub setId($){$_[0]->{id}=$_[1];}
sub addChangeable($){push(@{$_[0]->{changeables}},$_[1]);}
sub setGenerator{$_[0]->{generator}=$_[1];}
sub addURI($){push(@{$_[0]->{uris}},$_[1]);}
sub addURIToTop($){unshift(@{$_[0]->{uris}},$_[1]);}

sub isValid{1;}
sub clone{
  my $oS = shift;
  my $oSNew = new Scheduler::Sche;
  $oSNew->setId($oS->id);
  $oSNew->setGenerator($oS->generator->clone);
  $oSNew->addChangeable($_->clone) for @{$oS->changeables};
  $oSNew->addURI($_) for @{$oS->uris};
  return $oSNew;
}

1;
