package Scheduler::Data::XML::Sche::Location::GPX;
@ISA = qw|Scheduler::Data::XML::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Data::XML::base;
use Scheduler::Sche::Location::GPX;

use constant GPX_NAMESPACE => 'http://www.topografix.com/GPX/1/1';

sub obj($){
  shift;
  my $oGPX = new Scheduler::Sche::Location::GPX;
  my $oRoot = shift;
  my $oDocument = shift;
  my @a = $oRoot->getChildNodes;
  foreach(@a){
    if($_->localName eq 'wpt'){
      $oGPX->setLat($_->getAttribute('lat'));
      $oGPX->setLon($_->getAttribute('lon'));
      my @b = $_->getChildNodes;
      foreach(@b){
	if($_->localName eq 'name'){
	  $oGPX->setName($_->firstChild->nodeValue);
	}
      }
      last;
    }
  }
  return $oGPX;
}
sub element($){
  shift;
  my $oGPX = shift;
  my $oDocument = shift;
  my $oRoot = $oDocument->createElement('gpx');
  $oRoot->setNamespace(GPX_NAMESPACE,'gpx');
  my $oWPT = $oDocument->createElement('wpt');
  $oWPT->setAttribute('lat',$oGPX->lat);
  $oWPT->setAttribute('lon',$oGPX->lon);
  $oWPT->setAttributeNS(GPX_NAMESPACE,'lat',$oGPX->lat);
  $oWPT->setAttributeNS(GPX_NAMESPACE,'lon',$oGPX->lon);
  $oWPT->setNamespace(GPX_NAMESPACE,'gpx');
  my $oName = $oDocument->createElement('name');
  $oName->appendText($oGPX->name);
  $oName->setNamespace(GPX_NAMESPACE,'gpx');
  $oWPT->appendChild($oName);
  $oRoot->appendChild($oWPT);
  return $oRoot;
}

1;
