package Scheduler::Data::PlainText;
@ISA = qw|Module::DynamicSubModule Scheduler::Data::base|;

use Scheduler::Sche;
use Scheduler::Sche::Time;
use Scheduler::Data::XML::Sche;
use Scheduler::Data::PlainText::Imported;
use Module::DynamicSubModule;
use Module::SubModuleList;
use Scheduler::Data::base;
use Scheduler::FileLock;

use strict;
use warnings;
use Carp;

use IO::File;
use Encode qw|encode decode|;
use File::Find;
use Digest::MD5;

sub new(%){
    shift;
    my $oS =  Module::DynamicSubModule->new('Scheduler::Data::PlainText',shift,@_);
    if(defined $oS){
      $oS->optimize;
    }
    return $oS;
}
sub setPath($){$_[0]->{path}=$_[1];}
sub setIdentifier($){$_[0]->{identifier}=$_[1];}
sub path{$_[0]->{path};}
sub identifier{$_[0]->{identifier};}

sub generateNewID($){
    my $oS = shift;
    my $sSalt = shift || '';
    my $oIO = new IO::File($oS->path.'whole/.last');
    croak('Cannot find hidden counter file.') if !defined $oIO;
    my $nLast = <$oIO>;
    undef $oIO;
    $nLast++;
    $oIO = new IO::File('>'.$oS->path.'whole/.last');
    print $oIO $nLast;
    undef $oIO;
    my $sID = $oS->path.$nLast.$sSalt;
    my @asIDStrings = split(m||,$sID);
    my @asTmp = ();
    while(@asIDStrings){
      push(@asTmp,splice(@asIDStrings,int(rand(@asIDStrings)),1));
    }
    $sID = join('',@asTmp);
    $sID = encode('UTF-8',$sID) if Encode::is_utf8($sID);
    return new Digest::MD5->add($sID)->hexdigest.'.'.$oS->identifier;
}
sub getIDList($@){
    my $oS = shift;
    my ($sModule,@aParams) = @_;
    if(defined $sModule){
	my $oModule = new Scheduler::Data::PlainText($sModule,$oS->env);
	if(defined $oModule){
	  return $oModule->getIDList(@aParams);
	}
    }
    my @asResult = ();
    find(sub{
	   return if substr($_,0,1) eq '.';
	 },$oS->{path}.'whole/');
    return @asResult;
  }
sub getScheByID($){
    my $oS = shift;
    my $sID = shift;
    my $oScheCache = $oS->getLoaded($sID);
    return $oScheCache if defined $oScheCache;
    my $oIO = new IO::File($oS->path.'whole/'.$sID);
    return if !defined $oIO;
    my @asRess = $oIO->getlines;
    my $sRes = join('',@asRess);
    $sRes = decode('utf8',$sRes);
    my $oSche = Scheduler::Data::XML::Sche->objFromDocstring($sRes);
    my $oModule = new Scheduler::Data::PlainText::Imported($oS->env);
    if(!$oModule->itExpires($sID) && $oS->depth < 3){
      $oS->incDepth;
      return if $oS->depth > 3;
      $oS->reload($oSche);
      $oS->touchScheByID($sID);
      $oSche = $oS->getScheByID($sID);
      $oS->decDepth;
    }
    $oS->setLoaded($sID,$oSche);
    $oS->resetDepth;
    return $oSche;
}
sub touchScheByID($){
  my $oS = shift;
  my $sID = shift;
  utime(time,time,$oS->path.'whole/'.$sID);
}
sub getScheByIDFrom($$){
  my $oS = shift;
  my ($sID,$sModule,@aParams) = @_;
  if(defined $sModule){
    my $oModule = new Scheduler::Data::PlainText($sModule,$oS->env);
    return $oModule->getScheByID($sID);
  }
}
sub setSche($$$){
    my $oS = shift;
    my $oSche = shift;
    my $isImported = shift;
    my $sURIPrefix = shift;
    my $oPrevSche;
    croak('Scheduler::Sche is not defined') if !defined $oSche;
    $oSche->changeables->[0]->setModified(new Scheduler::Sche::Time::Optimized);
    $oSche->changeables->[0]->modified->setTime(Scheduler::Sche::Time->now);
    my $sID = $oSche->id;
    if(!defined $sID or $sID eq ''){
      $sID = $oS->generateNewID(Scheduler::Data::XML::Sche->docstringFromObj($oSche));
      if(defined $sURIPrefix){
	$oSche->addURI($sURIPrefix.$sID);
      }
      $oSche->setId($sID);
    }else{
      $oPrevSche = $oS->getScheByID($sID);
    }
    if(defined $oPrevSche){
      my @aoChangeables = @{$oPrevSche->changeables};
      $oSche->addChangeable($_) foreach @aoChangeables;
      my @aoURI = @{$oPrevSche->uris};
      if(defined $aoURI[0]){
	shift @aoURI;
	$oSche->addURI($_) foreach @aoURI;
      }
    }
    $oS->updateSche($sID,$oSche);
    &Module::SubModuleList::findAndDo('Scheduler::Data::PlainText',
				      'setSche',
				      [$sID,$isImported], # Parameters for subroutine setSche($$) in sub modules
				      $oS->env);
    return ();
}
sub updateSche($){
  my $oS = shift;
  my ($sID,$oSche) = @_;
  my $oIO = new IO::File('> '.$oS->path.'whole/'.$sID);
  croak('Cannot open '.$oS->path.'whole/'.$sID.' : is not writable for user id '.$>) if !defined $oIO;
  my $sSche = Scheduler::Data::XML::Sche->docstringFromObj($oSche);
  $sSche = encode('utf8',$sSche) if Encode::is_utf8($sSche);
  my $lfh = Scheduler::FileLock->my_flock or die 'Busy!';
  print $oIO $sSche;
  undef $oIO;
  Scheduler::FileLock->my_funlock($lfh);
  chmod(0666,$oS->path.'whole/'.$sID);
}
sub delScheByID($){
  my $oS = shift;
  my $sID = shift;
  if(defined $sID){
    unlink($oS->path.'whole/'.$sID);
    &Module::SubModuleList::findAndDo('Scheduler::Data::PlainText',
				      'delScheByID',
				      [$sID],
				      $oS->env);
  }
}
{
  my $isPathOptimized = 0;

  sub optimizePath{
    my $oS = shift;
    if(!$isPathOptimized){
      $isPathOptimized = 1;
      croak('The data root directory is root!') if !defined $oS->{path} or $oS->{path} eq '';
      $oS->{path} .= '/' unless $oS->{path} =~ m|/$|;
      $oS->makeDirectory($oS->{path});
      $oS->makeDirectory($oS->{path},'whole');
      my $sFilePath = $oS->{path}.'whole/.last';
      if(!-e $sFilePath){
	croak('Cannot make hidden counter file for plaintext database in directory '.$oS->{path}.'whole/'.' : is not writable for user id '.$>) if !-w $oS->{path}.'whole/';
      my $oS = new IO::File('>'.$sFilePath);
	if(defined $oS){
	  print $oS "0\n";
	  undef $oS;
	  chmod(0666,$sFilePath);
	}
      }
    }
  }
}
{
  my $isOptimized = 0;
  sub optimize{
    my $oS = shift;
    $oS->optimizePath;
    if(!$isOptimized){
      $isOptimized = 1;
      &Module::SubModuleList::findAndDo('Scheduler::Data::PlainText',
					'makeDir',
					[],
					$oS->env);
    }
  }
}
sub resetIdNum($){
    my $oS = shift;
    my $nD = shift;
    $nD = 0 if !defined $nD;
    my $oO = new IO::File('>'.$oS->path.'whole/.last');
    croak('Cannot make '.$oS->path.'whole/.last') if !defined $oO;
    print $oO $nD;
    undef $oO;
}
sub env(){
  my $oS = shift;
  return (
	  path => $oS->{path},
	  encoding => $oS->{encoding},
	  identifier => $oS->{identifier},
	  refresh_interval => $oS->{refresh_interval},
	 );
}
sub makeDirectory($$$){
  my $oS = shift;
  my ($sBaseDir,$sMakingFile,$sPermission) = @_;
  $sPermission = 0777 if !defined $sPermission;
  my $sNewFilePath;
  if(defined $sMakingFile){
    $sNewFilePath = $sBaseDir.'/'.$sMakingFile;
  }else{
    $sNewFilePath = $sBaseDir;
  }
  if(!-e $sNewFilePath or !-d $sNewFilePath){
    unlink($sNewFilePath);
    mkdir($sNewFilePath);
    $oS->croakIfCannotMakeFile($sBaseDir);
    chmod($sPermission,$sNewFilePath);
  }
}
sub croakIfCannotMakeFile($){
  my $oS = shift;
  my $sNewFileDir = $_[0];
  croak('Cannot make sub root directory for status sort inside plaintext database in '.$sNewFileDir.' : is not writable for user id. '.$oS->writePermission) if !-w $sNewFileDir;
}
sub croakIfCannotDeleteFile($){
  my $oS = shift; 
  my $sNewFileDir = $_[0];
  croak('Cannot delete file '.$sNewFileDir.' : is not writable for user id. '.$oS->writePermission) if !-w $sNewFileDir;
}
sub writePermission($){
  my $oS = shift;
  my $sNewFileDir = $_[0];
  return $>.sprintf("%d",(stat($sNewFileDir))[2]);
}
{
  my %hLoaded = ();
  sub setLoaded($$){
    shift;
    $hLoaded{$_[0]} = $_[1];
  }
  sub getLoaded($){
    shift;
    return $hLoaded{$_[0]};
  }
}
{
  my $nDepth = 0;
  sub incDepth(){
    shift;
    $nDepth++;
  }
  sub decDepth(){
    shift;
    $nDepth--;
  }
  sub depth(){
    shift;
    return $nDepth;
  }
  sub resetDepth(){
    shift;
    $nDepth = 0;
  }
}

1;
