package Section::Xsche;
@ISA = qw|Section::base|;

use strict;
use warnings;
use Carp;

use Section::base;
use Scheduler::Feed;
use Encode qw|encode|;

use Scheduler::Data::XML::Feed;

sub new{
  shift;
  return bless Section::base->new(@_);
}
sub out{
  my $oS = shift;
  my @asIDs = $oS->oCGI->param('id');
  return '' if scalar(@asIDs) == 0;
  my $oFeed = new Scheduler::Feed;
  my $oGen = new Scheduler::Generator();
  $oGen->setName($oS->oEnv->generatorName);
  $oGen->setVersion($oS->oEnv->scriptVersion);
  $oFeed->setGenerator($oGen);
  foreach(@asIDs){
    my $oSche = $oS->oDat->getScheByID($_);
    next if !defined $oSche;
    if(scalar(@{$oSche->uris}) == 0){
      $oSche->addURI($oS->oEnv->storageURI.'?mode=xsche&id='.$oSche->id);
    }
    $oFeed->addSche($oSche);
  }
  my $sSche = Scheduler::Data::XML::Feed->docstringFromObj($oFeed);
  $sSche = encode('utf-8',$sSche) if utf8::is_utf8($sSche);
  print 'Content-Disposition: attachment;filename="feed.sche2"'."\n";
  print $oS->oCGI->header(
			  -connection => 'close',
			  -type => 'application/xsche+xml;name="test.sche2"',
			  -expires => '+0h',
			  -encoding => 'utf-8',
			  -status => '200 OK',
			  -size => length $sSche,
			 );
  print $sSche;
}

1;
