package Section::Login;
@ISA = qw|Section::base|;

use strict;
use warnings;
use Carp;

use Section::base;

sub new{
  shift;
  return bless Section::base->new(@_);
}
sub out{
  my $oS = shift;
  $oS->oOut->setSubtitle('Login');
  my ($sUser,$sPass) = ($oS->oCGI->param('login_name'),$oS->oCGI->param('login_password'));
  if(!$oS->oLgi->isLoggedIn && 
     (!defined $sUser ||
      !defined $sPass ||
      !$oS->oLgi->isUserValid($sUser,$sPass)
     )){
    print $oS->outLoginForm;
  }else{
    print $oS->outLoggedIn;
  }
}
sub outLoginForm{
  my $oS = shift;
  my $sOut = $oS->oOut->httpHeader.$oS->oOut->htmlHeader;
  my $sWrong = '';
  $oS->setHistoryStack('login');
  if($oS->getIndexOfHistoryStack(-1) eq 'login' && $oS->getIndexOfHistoryStack(-2) eq 'login'){
    $oS->removeHistoryStack;
    $sWrong = '<strong>'.$oS->getEncLng('LOGIN_IS_WRONG').'</strong>';
  }
  $oS->oLgi->killCookie;
  $oS->oLgi->killSession;
  $sOut .= $oS->oOut->sectionBegin('LOGIN','login');
  $sOut .= $sWrong;
  $sOut .= '<p>'.$oS->getEncLng('LOGIN_PLEASE_ENTER').'</p>';
  $sOut .= '<form method="post" action="index.cgi"><input type="hidden" name="hstack" value="'.$oS->getHistoryStack.'"><input type="hidden" name="mode" value="login" /><p>'.$oS->getEncLng('LOGIN_USER').':<input type="text" name="login_name" value="" /></p><p>'.$oS->getEncLng('LOGIN_PASSWORD').'<input type="password" name="login_password" value="" /></p><input type="submit" value="'.$oS->getEncLng('LOGIN_DO').'" /></form>';
  return $sOut.$oS->oOut->sectionEnd.$oS->oOut->htmlFooter;
}
sub outLoggedIn{
  my $oS = shift;
  $oS->oLgi->login;
  return $oS->oCGI->redirect('index.cgi?sid='.$oS->oLgi->sessionId);
}

1;
