package Output;

use strict;
use warnings;
use Carp;

use CGI qw|:standard|;
use Encode qw|encode decode|;

sub new(%){
    shift;
    my %hE = @_;
    return bless{
		 encoding => $hE{encoding} || 'utf8',
		 dataDirUri => $hE{dataDirUri} || '',
		 oLng => $hE{oLng},
		 oEnv => $hE{oEnv},
		 oLgi => $hE{oLgi},
		 asHeadersEx => [],
		 hsBodyTagAttributes => {},
		 isUsingPrototypeJS => 0,
		 isUsingEscapeCodecLibrary => 0,
		 subtitle => '',
    };
}
sub oLng{$_[0]->{oLng};}
sub oEnv{$_[0]->{oEnv};}
sub oLgi{$_[0]->{oLgi};}
sub oOut{$_[0];}
sub isUsingPrototypeJS{$_[0]->{isUsingPrototypeJS} = 1;}
sub isUsingEscapeCodecLibrary{$_[0]->{isUsingEscapeCodecLibrary} = 1;}
sub sEncoding{$_[0]->{encoding};}
sub addHeaderEx{
  push(@{$_[0]->{asHeadersEx}},$_[1]);
}
sub setHeaderEx{
  $_[0]->{asHeadersEx} = [$_[1]];
}
sub setSubtitle{
  $_[0]->{subtitle} = $_[1];
}
sub setBodyTagAttribute{
  $_[0]->{hsBodyTagAttributes}->{$_[1]} = $_[2];
}
sub appendBodyTagAttribute{
  $_[0]->{hsBodyTagAttributes}->{$_[1]} = '' if !exists $_[0]->{hsBodyTagAttributes}->{$_[1]};
  $_[0]->{hsBodyTagAttributes}->{$_[1]} .= $_[2];
}
sub encoded{
    my $oS = shift;
    return encode($oS->{encoding},$_[0]);
}
sub decoded{
  my $oS = shift;
  return decode($oS->{encoding},$_[0]);
}
sub sectionBegin{
  my $oS = shift;
  if(!defined $_[1]){
    return '<div class="section" id="'.$_[0].'">';
  }else{
    return qq|<div class="section" id="$_[1]"><h1>|.encode($oS->{encoding},$oS->oLng->get($_[0])).'</h1>';
  }
}
sub sectionEnd{
    shift;
    return '</div>';
}
sub httpHeader(%){
	my $oS = shift;
	my %hE = @_;
	my %hsHeaderParams = (
			    -expires => '+0h',
			    -type => 'text/html',
			    -status => '200 OK',
			    -charset => $oS->{encoding},
			   );
	$hsHeaderParams{-cookie} = [];
	if(exists $hE{cookie}){
	  push(@{$hsHeaderParams{-cookie}},$hE{cookie});
	}
	foreach($oS->oLgi->sessionCookies){
	  push(@{$hsHeaderParams{-cookie}},$_);
	}
	my $oCGI = new CGI;
	my $sR = $oCGI->header(%hsHeaderParams);
	return $sR;
      }
sub htmlHeader(%){
	my $oS = shift;
	my %hE = @_;
	my $sSubtitle = $oS->{subtitle};
	my $sR .= qq|<?xml version="1.0" encoding="$oS->{encoding}"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja"><head><title>Sche::STORAGE $sSubtitle</title><link rel="stylesheet" type="text/css" href="$oS->{dataDirUri}/style.css" /><meta http-equiv="Content-Type" content="text/html" charset="$oS->{encoding}" />|;
	$sR .= '<script type="text/javascript" src="'.$oS->{dataDirUri}.'/prototype.js"></script>' if $oS->{isUsingPrototypeJS};
	$sR .= '<script type="text/javascript" src="'.$oS->{dataDirUri}.'/ecl.js"></script>' if $oS->{isUsingEscapeCodecLibrary};
	$sR .= join('',@{$oS->{asHeadersEx}});
	$sR .= '</head>';
	$sR .= '<body ';
	foreach(keys %{$oS->{hsBodyTagAttributes}}){
	  my $sAt = $oS->{hsBodyTagAttributes}->{$_};
	  $sAt =~ s|&|\&amp;|g;
	  $sR .= $_.'="'.$sAt.'" ';
	}
	$sR .= '>';
	$sR .= << 'EOF';
<div id="root"><div id="header"><h1><a href="index.cgi?"><span>Sche::STORAGE</span></a></h1></div>
EOF
	$sR .= $oS->sectionBegin('headmenu');
	if($oS->oLgi->isLoggedIn){
        $sR .= '<ul><li><a href="index.cgi?">'.$oS->oOut->encoded($oS->oLng->get('BACK_TO_LIST')).'</a></li>';
	  $sR .= '<li><a href="index.cgi?mode=edit">'.$oS->oOut->encoded($oS->oLng->get('NEW'))
	    .'</a></li><li><a href="index.cgi?mode=import">'
	      .$oS->oOut->encoded($oS->oLng->get('IMPORT'))
#		.'</a></li><li><a href="index.cgi?mode=channel">'
#		  .$oS->oOut->encoded($oS->oLng->get('CHANNEL'))
		    .'</a></li><li><a href="index.cgi?mode=locationlib">'
		      .$oS->oOut->encoded($oS->oLng->get('LOCATIONLIB'))
			.'</a></li><li><a href="index.cgi?mode=setting">'
			  .$oS->oOut->encoded($oS->oLng->get('SETTING'))
			    .'</a></li><li><a href="index.cgi?mode=logout">'
			      .$oS->oOut->encoded($oS->oLng->get('LOGOUT'))
				.'</a></li></ul>';
	}else{
	  $sR .= '<ul><li><a href="index.cgi?">'.$oS->oOut->encoded($oS->oLng->get('BACK_TO_LIST')).'</a></li><li><a href="index.cgi?mode=login">'.$oS->oOut->encoded($oS->oLng->get('LOGIN'))
	    .'</a></li></ul>';
	}
	$sR .= $oS->sectionEnd;
	return $sR;
}
sub htmlFooter{
    my $oS = shift;
    return qq|<div id="footer"><h1><a href="http://sche-storage.sourceforge.jp/">Version |.$oS->oEnv->scriptVersion.qq|</a></h1><p>Scripted by xor</p></div></body></html>\n|;
}

1;
