using System;
using System.IO;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;

namespace SCFiler2.Action {
	public class PasteClipboard : Action {
		public override string DisplayString {
			get { return "Nbv{[h\t"; }
		}

		public override void execute() {
			MainForm main_form = MainForm.Instance;
			//TODO Nbv{[hViewŐVǂ`FbN(ŐVȂXVă_CAO\return)

			if (ClipboardManager.isConatinFiles() == false) {
				SCFiler2System.showTempMessage("Nbv{[h͋ł");
				return;
			}

			if (main_form.FocusedViewType == MainForm.EFocusedViewType.FileView) {
				//Nbv{[h烊Xg쐬
				List<FilerItem> items_in_clipboard = new List<FilerItem>();
				foreach (string file in Clipboard.GetFileDropList()) {
					items_in_clipboard.Add(FilerItem.createItem(file));
				}
				ClipboardManager.EffectType paste_type = ClipboardManager.getDropEffect();
				FileView target_view = main_form.getLastFocusedFileView();

				//y[XgiRs[܂͈ړjs
				if (paste_type == ClipboardManager.EffectType.Copy) {
					FilerItem.copy(items_in_clipboard, target_view.CurrentPath);
					Clipboard.Clear();
					target_view.updateView();
					main_form.checkUpdateAllView();
				} else if (paste_type == ClipboardManager.EffectType.Cut) {
					FilerItem.move(items_in_clipboard, target_view.CurrentPath);
					Clipboard.Clear();
					target_view.updateView();
					main_form.checkUpdateAllView();
				}
			} else {
				main_form.printToStatusbar("FileViewɃtH[JX܂");
			}
		}
	}

}
