﻿using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Util;
using System.Windows.Forms;

namespace SCFiler2.FileSystem {
	/// <summary>
	/// JumpFolderManager。シングルトン。
	/// </summary>
	public class JumpFolderManager {
		static JumpFolderManager instance = new JumpFolderManager();
		static public JumpFolderManager Instance {
			get {return instance;}
		}

		private List<JumpFolder> jump_folder_list = new List<JumpFolder>();
		int load_folder_num = 0; //saveするときに前回よりフォルダ数が減ってたら、nullを埋めるために記録しておく

		private JumpFolderManager() {
			load();
		}

		public List<JumpFolder> JumpFolders {
			get {
				return jump_folder_list;
			}
		}

		private void load() {
			SettingFile file = SettingFile.Instance;
			string str = file.load("JumpFolder", "Number");
			try {
				load_folder_num = int.Parse(str);

				//１個１個読み込む
				for (int i = 0; i < load_folder_num; i++) {
					string tmp_str = file.load("JumpFolder", "Folder" + i);
					string[] strs = tmp_str.Split(',');
					jump_folder_list.Add(new JumpFolder(strs[0], strs[1]));
				}
			} catch (Exception e) {
				//T.B.D エラー処理をあとで作る
			}
		}

		private void save() {
			SettingFile file = SettingFile.Instance;
			//全体データを登録
			file.save("JumpFolder", "Number", jump_folder_list.Count.ToString());

			//全フォルダを１個１個登録
			for (int i = 0; i < jump_folder_list.Count; i++) {
				file.save("JumpFolder", "Folder" + i, jump_folder_list[i].Title + "," + jump_folder_list[i].Folder.Info.FullName);
			}
			//前回より減った場合はnullを渡して項目を無くす
			for (int i = jump_folder_list.Count; i < load_folder_num; i++) {
				file.save("JumpFolder", "Folder" + i, null);
			}
		}

		public void addFolder(JumpFolder jump_folder) {
			foreach (JumpFolder folder in jump_folder_list) {
				if (folder.Folder.Info.FullName == jump_folder.Folder.Info.FullName || folder.Title == jump_folder.Title) {
					MessageBox.Show("すでに登録されています");
					return;
				}
			}
			if (!System.IO.Directory.Exists(jump_folder.Folder.Info.FullName)) {
				MessageBox.Show("無効なフォルダを登録しようとしています");
				return;
			}
			jump_folder_list.Add(jump_folder);
			save();
		}

		/// <summary>
		/// target_itemの登録順番を一つ上のアイテムと入れ替える
		/// </summary>
		/// <param name="target_item"></param>
		public void itemOrderUp(JumpFolder target_item) {
			for (int i = 0; i < jump_folder_list.Count; i++) {
				if (target_item.Title == jump_folder_list[i].Title) {
					if (i == 0) {
						return; //一番上のアイテムなので何もできない
					}
					JumpFolder tmp_item = jump_folder_list[i - 1];
					jump_folder_list[i - 1] = jump_folder_list[i];
					jump_folder_list[i] = tmp_item;
					return;
				}
			}
			save();
		}

		/// <summary>
		/// target_itemの登録順番を一つ下のアイテムと入れ替える
		/// </summary>
		/// <param name="target_item"></param>
		public void itemOrderDown(JumpFolder target_item) {
			for (int i = 0; i < jump_folder_list.Count; i++) {
				if (target_item.Title == jump_folder_list[i].Title) {
					if (i == jump_folder_list.Count - 1) {
						return; //最後のアイテムなので何もできない
					}
					JumpFolder tmp_item = jump_folder_list[i + 1];
					jump_folder_list[i + 1] = jump_folder_list[i];
					jump_folder_list[i] = tmp_item;
					return;
				}
			}
			save();
		}
	}
}
