using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using SCFiler2.FileSystem;
using System.Windows.Forms;

namespace SCFiler2 {
	public class FileViewComparer : IComparer {
		ColumnType column;
		private enum ColumnType :int {
			FileName = 0,
			Extension = 1,
			Size = 2,
			UpdateDate = 3
		}

		public FileViewComparer(int column_number) {
			column = (ColumnType)column_number;
		}

		public void setColumn(int column_number) {
			column = (ColumnType)column_number;
		}

		public int Compare(Object x, Object y) {
			FilerItem item_a = (FilerItem)(((ListViewItem)x).Tag);
			FilerItem item_b = (FilerItem)(((ListViewItem)y).Tag);

			if (item_a.Type != item_b.Type) {
				//tH_ɕ\
				if (item_a.Type == FilerItem.ItemType.Folder) return -1;
				else return 1;
			} else {
				if (item_a.Type == FilerItem.ItemType.Folder) {
					switch (column) {
						case ColumnType.FileName:
							return String.Compare(item_a.Info.Name, item_b.Info.Name);
						case ColumnType.Extension:
							return -1;
						case ColumnType.Size:
							return -1;
						case ColumnType.UpdateDate:
							return DateTime.Compare(item_a.Info.LastWriteTime, item_b.Info.LastWriteTime);
						default:
							return -1;
					}
				} else {
					switch (column) {
						case ColumnType.FileName:
							return String.Compare(item_a.Info.Name, item_b.Info.Name);
						case ColumnType.Extension:
							return String.Compare(item_a.Info.Extension, item_b.Info.Extension);
						case ColumnType.Size:
							return ((File)item_a).Size > ((File)item_b).Size ? 1 : -1;
						case ColumnType.UpdateDate:
							return DateTime.Compare(item_a.Info.LastWriteTime, item_b.Info.LastWriteTime);
						default:
							return -1;
					}
				}
			}
		}
	}
}
