using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SCFiler2.Action;
using SCFiler2.Util;
using SCFiler2.FileSystem;

namespace SCFiler2 {
	public partial class MainForm : Form {
		static private MainForm instance = null;

		#region r[ւ̃ANZX֘A
		public enum EFocusedViewType {
			FileView,
			HistoryView,
			Other
		}
		private EFocusedViewType focused_view_type = EFocusedViewType.Other;
		public EFocusedViewType FocusedViewType {
			get { return focused_view_type; }
			set { focused_view_type = value; }
		}
		private FileView last_focused_fileview = null;
		private HistoryView last_focused_historyview = null;

		public FileView LeftFileView {
			get { return left_file_listview; }
		}

		public FileView RightFileView {
			get { return right_file_listview; }
		}

		/// <summary>
		/// ݃tH[JXĂFileViewAɃtH[JXȂꍇ͍ŌɂقԂ
		/// Focusedł͂ȂLastFocusedɂĂ̂́A_CAOɃtH[JXƂɂg悤ɁB
		/// </summary>
		public FileView getLastFocusedFileView() {
			return last_focused_fileview;
		}

		/// <summary>
		/// tH[JXړƂMainFormɒʒm
		/// </summary>
		/// <param name="focused_view">VFocusFileView</param>
		public void notifyFileViewFocused(FileView focused_view) {
			last_focused_fileview = focused_view;
			focused_view_type = EFocusedViewType.FileView;
		}

		/// <summary>
		/// QFileVieŵŗ^ꂽFileView̔΂FileViewԂ
		/// </summary>
		/// <param name="file_view"></param>
		/// <returns>Ɣ΂FileView</returns>
		public FileView getAnotherFileView(FileView file_view) {
			if (file_view == left_file_listview) {
				return right_file_listview;
			} else {
				return left_file_listview;
			}
		}

		/// <summary>
		/// HistoryViewtH[JX󂯎ƂMainFormɒʒm
		/// </summary>
		/// <param name="focused_view">VtH[JXHistoryView</param>
		public void notifyHistoryViewFocused(HistoryView focused_view) {
			last_focused_historyview = focused_view;
			focused_view_type = EFocusedViewType.HistoryView;
		}

		/// <summary>
		/// ݃tH[JXĂHistoryViewASɃtH[JXȂꍇ͍ŌɂViewԂ
		/// </summary>
		public HistoryView getLastFocusedHistoryView() {
			return last_focused_historyview;
		}

		private FolderHistoryManager folder_history_manager = null;
		private FileHistoryManager file_history_manager1 = null;
		private FileHistoryManager file_history_manager2 = null;

		public FileHistoryManager FileHistoryManager1 {
			get { return file_history_manager1; }
		}

		public FileHistoryManager FileHistoryManager2 {
			get { return file_history_manager2; }
		}

		private List<HistoryManager> all_history_manager = new List<HistoryManager>();
		public List<HistoryManager> AllHistoryManager {
			get { return all_history_manager; }
		}

		private List<HistoryView> all_history_view = new List<HistoryView>();
		public List<HistoryView> AllHistoryView {
			get { return all_history_view; }
		}

		#endregion r[ւ̃ANZX֘A


		public MainForm() {
			instance = this;

			InitializeComponent();

			//TODO łŃL[o^Ă
			KeyCommandManager keycommand_manager = KeyCommandManager.Instance;
			keycommand_manager.load();

			//c[o[̕`
			drawDriveToolbar();

			//t@Cr[̏
			left_file_listview.initialize("LeftFileView");
			right_file_listview.initialize("RightFileView");

			//r[̏
			folder_history_manager = new FolderHistoryManager(folder_history, "tH_");
			folder_history.initialise(folder_history_manager,"tH_");
			all_history_manager.Add(folder_history_manager);
			folder_history_manager.load();
			folder_history.updateView();

			file_history_manager1 = new FileHistoryManager(file_history1, "t@C1");
			file_history1.initialise(file_history_manager1, "t@C1");
			all_history_manager.Add(file_history_manager1);
			file_history_manager1.load();
			file_history1.updateView();

			file_history_manager2 = new FileHistoryManager(file_history2, "t@C2");
			file_history2.initialise(file_history_manager2, "t@C2");
			all_history_manager.Add(file_history_manager2);
			file_history_manager2.load();
			file_history1.updateView();
			
		}

		/// <summary>
		/// MainForm̃CX^Xn
		/// </summary>
		static public MainForm Instance {
			get { return instance; }
		}

		private void MainForm_KeyDown(object sender, KeyEventArgs e) {
			if (KeyCommandManager.Instance.executeAction(e.Control, e.Alt, e.Shift, e.KeyCode) == true) {
				e.Handled = true;
			}
		}

		private void MainForm_FormClosing(object sender, FormClosingEventArgs e) {
			SettingFile file = SettingFile.Instance;
			//݂̃tH[̏Ԃۑ
			if (WindowState == FormWindowState.Normal) {
				file.save("Location", "Height", this.Height.ToString());
				file.save("Location", "Width", this.Width.ToString());
			}

			//t@Cr[̏I
			left_file_listview.terminate();
			right_file_listview.terminate();

			//r[̃f[^ۑ
			foreach (HistoryManager manager in AllHistoryManager) {
				manager.save();
			}
		}

		private void MainForm_Load(object sender, EventArgs e) {
			SettingFile file = SettingFile.Instance;
			//tH[̏Ԃǂݍ
			String h_str = file.load("Location", "Height");
			String w_str = file.load("Location", "Width");
			try {
				this.Height = int.Parse(h_str);
				this.Width = int.Parse(w_str);
			} catch {
				this.Height = 600;
				this.Width = 800;
			}
		}

		/// <summary>
		/// c[o[̃hCuꗗ`悷
		/// </summary>
		private void drawDriveToolbar() {
			drive_toolbar.Items.Clear();

			System.IO.DriveInfo[] drives = System.IO.DriveInfo.GetDrives();
			foreach (System.IO.DriveInfo drive in drives) {
				string button_text = "";
				try {
					button_text = drive.VolumeLabel + "(" + drive.Name + ")";
				} catch (Exception) {
					//[oufBXNĂȂă{[xŗONƂ́A[gfBNg\
					button_text = drive.Name;
				}
				ToolStripButton button = new ToolStripButton(button_text, null, changeDrive);
				button.Tag = drive;
				drive_toolbar.Items.Add(button);
			}
		}

		/// <summary>
		/// ANeBuFileView̃hCuύXBihCuꗗc[o[p̃Cxgnhj
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public void changeDrive(object sender, EventArgs e) {
			ToolStripButton button = (ToolStripButton)sender;
			FileView view = getLastFocusedFileView();
			System.IO.DriveInfo drive_info = (System.IO.DriveInfo)button.Tag;
			view.setPath(drive_info.Name);
			view.updateView();
		}

		/// <summary>
		/// Xe[^Xo[ɕ\
		/// </summary>
		/// <param name="text">\镶</param>
		public void printToStatusbar(string text) {
			statusbar_area1.Text = text;
		}


		/// <summary>
		/// eLXg\GAɕǉ
		/// </summary>
		/// <param name="text">\</param>
		public void printToMessageHistoryArea(string text) {
			message_history_textbox.AppendText(text + "\r\n");
		}

		private void ݒOToolStripMenuItem_Click(object sender, EventArgs e) {
			OptionDialog dialog = new OptionDialog();
			dialog.ShowDialog();
		}

		private void GNXv[ŊJOToolStripMenuItem_Click(object sender, EventArgs e) {
			Action.Action.OpenByExplorer.execute();
		}

		private void WvtH_ɒǉAToolStripMenuItem_Click(object sender, EventArgs e) {
			Action.Action.AddToJumpFolder.execute();
		}

		private void tool_strip_ItemClicked(object sender, ToolStripItemClickedEventArgs e) {

		}

		private void IXToolStripMenuItem_Click(object sender, EventArgs e) {
			Action.Action.ExitApplication.execute();
		}
	}
}