#!/bin/sh
# This is a preprocessor for 'less'.  It is used when this environment
# variable is set:   LESSOPEN="|lesspipe.sh %s"
# This script is modified for japanese nroff
#                          by manabe@papilio.tutics.tut.ac.jp
# modified to view gzipped nroff file by Jun Nishii <jun@vinelinux.org>

{

  if [ -d "$1" ]; then
        ls -al "$1"
  else
  case "$1" in
  *.1|*.2|*.3|*.4|*.5|*.6|*.7|*.8|*.9|*.n|*.man|*.jman|\
    *.1x|*.2x|*.3x|*.4x|*.5x|*.6x|*.7x|*.8x|*.9x|*.nx|\
    *.1.gz|*.2.gz|*.3.gz|*.4.gz|*.5.gz|*.6.gz|*.7.gz|*.8.gz|*.9.gz|*.n.gz|*.man.gz|*.jman.gz|\
    *.1x.gz|*.2x.gz|*.3x.gz|*.4x.gz|*.5x.gz|*.6x.gz|*.7x.gz|*.8x.gz|*.9x.gz|*.nx.gz)
    FILE=`file -bziL $1` ;
    FILE=`echo $FILE | cut -d ' ' -f 1`
    if [ "$FILE" = "text/troff;" -o "$FILE" = "troff" ]; then
    if [ "${1##*.}" = "gz" ]; then
    CAT=zcat
    else
    CAT=cat
    fi
    if [ -d /usr/lib/groff/font/devnippon ]; then
    $CAT $1 | groff -s -p -t -e -Tnippon -mandoc
    else
    $CAT $1 | groff -s -p -t -e -Tascii -mandoc
    fi
    elif [ "${FILE%%/*}" = "text" ] ;then 
    if [ "${1##*.}" = "gz" ]; then
    gzip -dc $1  2>/dev/null
    fi
    fi ;;
  *.tar) tar tvvf $1 2>/dev/null ;; # View contents of .tar and .tgz files
  *.tgz) tar tzvvf $1 2>/dev/null ;;
  *.tbz) tar tvvf $1 --bzip2 2>/dev/null ;;
  *.tar.gz) tar tzvvf $1 2>/dev/null ;;
  *.tar.Z) tar tzvvf $1 2>/dev/null ;;
  *.tar.z) tar tzvvf $1 2>/dev/null ;;
  *.tar.bz2) tar tvvf $1 --bzip2 2>/dev/null ;;
  *.Z) gzip -dc $1  2>/dev/null ;; # View compressed files correctly
  *.z) gzip -dc $1  2>/dev/null ;;
  *.bz2) bzip2 -dc $1  2>/dev/null ;;
  *.gz) gzip -dc $1  2>/dev/null ;;
  *.zip) unzip -l $1 2>/dev/null ;;
  *.lzh) lha l $1 2>/dev/null ;;
# *.nosrc.rpm|*.src.rpm) rpm -qivlp $1 --changelog 2>/dev/null ;;
# *.rpm) rpm -qivlp $1 2>/dev/null ;;
  *.rpm) rpm -qlp $1 2>/dev/null ;;
#  *) FILE=`file -L $1` ; # Check to see if binary, if so -- view with 'strings'
#    FILE1=`echo $FILE | cut -d ' ' -f 2`
#    FILE2=`echo $FILE | cut -d ' ' -f 3`
#    if [ "$FILE1" = "Linux/i386" -o "$FILE2" = "Linux/i386" \
#         -o "$FILE1" = "ELF" -o "$FILE2" = "ELF" ]; then
#      strings $1
#    fi ;;
  esac
  fi
} 2>/dev/null
