/*
 * Test program for Vector Font Library VFlib 2
 *
 *  Programmed by Hirotsugu KAKUGAWA, Hiroshima University
 *  E-Mail:  kakugawa@se.hiroshima-u.ac.jp
 *
 * Edition History
 *  31 Oct 1993
 *   5 Nov 1993
 *  19 Jan 1994  Added Outline test mode
 *  24 May 1994  changed so that vftest can be used with color displays
 */


/* This file is part of VFlib
 *
 * Copyright (C) 1993 Hirotsugu KAKUGAWA.   All rights reserved.
 *
 * VFlib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
 * to anyone for the consequences of using it or for whether it serves any
 * particular purpose or works at all, unless he says so in writing.  Refer
 * to the GNU General Public License for full details.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * VFlib, but only under the conditions described in the GNU
 * General Public License.  A copy of this license is supposed to have been
 * given to you along with VFlib so you can know your rights and
 * responsibilities.  It should be in a file named COPYING.  Among other
 * things, the copyright notice and this notice must be preserved on all
 * copies. 
 */



/*** 
 ***   CAUTION!!    THIS FILE CONTAINS 8-BIT EUC KANJI CHARACTER CODES
 ***/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include "../src/VF.h"
#include "../src/config.h"
#include "str.h"

/* Default Pixel Size */
#define T_XDOTS      70
#define T_YDOTS      40
#define W_XDOTS     100
#define W_YDOTS     100

#define	etoj(c1, c2)	{c1 &= 0x7f; c2 &= 0x7f;}
#define	iseuc1st(c)	((c) >= 0xa1 && (c) <= 0xfe)


int  XDots,  YDots, XBytes;
int  WYMargin; 
int  Frame;

/** THIS IS EUC KANJI TEXT **/
static char *Str[] = {
  "ɥ",
  "",
  "í軭Ұ",
  "ϤˤۤؤȤ",
  "£ãģţƣǣȣɣ",
  "",
  "󡰡ʡˡΡϡܡáǡ䡢",
  "֥ӥǸ뤨ס˼",
  "ֺ⸵ʤΤסʥݥ",
  "ܿͤǤ",
  "",
  "",
  ""
  };
#define SAMPLE_STRS  13

void Dump(), XDump();


int
main(argc, argv)
  int  argc;
  char **argv;
{
  int           Fd, Ccode, Tty, Len, Skip, Sno, OutlineTest, Pos, i, 
                SkipDots, WidthDots, UseFSlib;
  char          *Ent, *Vfcap, *Buff;
  unsigned char *p;
  long          *vfdata;
  int            euc2jis();

  Vfcap  = NULL;
  Ent    = "min";
  OutlineTest = 0;
  XDots  = T_XDOTS;
  YDots  = T_YDOTS;
  Tty    = 0;
  XDots  = W_XDOTS;
  YDots  = W_YDOTS;
  WYMargin = (int) (0.1*YDots);
  Skip   = 100; 
  Sno    = 0;
  Frame  = 1;
  UseFSlib = 0;

  for (i = 1; i < argc; i++){
    if (argv[i][0] == '-')
      switch (argv[i][1]){
      case 'f':
	Ent = argv[++i];
	break;
      case 'F':
	UseFSlib = 1;
	break;
      case 'x':
	XDots = atoi(argv[++i]); 
	break;
      case 'y':
	YDots = atoi(argv[++i]); 
	WYMargin = (int) (0.1*YDots);
	break;
      case 'w':
	Tty    = 0;
	XDots  = W_XDOTS;
	YDots  = W_YDOTS;
	WYMargin = (int) (0.1*YDots);
	break;
      case 'o':
	OutlineTest = 1;
	break;
      case 'v':
	Vfcap = argv[++i];
	break;
      case 's':
	Sno = atoi(argv[++i]);
	if ((Sno < 0) || (SAMPLE_STRS <= Sno))
	  Sno = 0;
	break;
      case 'r':
	Frame = 0;
	break;
      case 't':
	Tty    = 1;
	break;
      case 'i':
	Skip = atoi(argv[++i]); 
	break;
      case 'h':
      default:
	printf("vftest  - test program for VFlib 2\n");
	printf("Usage vftest [options]\n");
	printf("options: \n");
	printf(" -f FONT_ENTRY  : specify font entry name. %s\n",
	       "(`min' is default)");
	printf(" -x DOTS        : set character width.\n");
	printf(" -y DOTS        : set character height.\n");
	printf(" -w             : display bitmap in a window. (use X-Window)\n");
	printf(" -t             : display bitmap on tty.\n");
	printf(" -v             : set vfontcap file. (must give full path)\n");	
	printf(" -s             : specify no. of sample string. (0..%d)\n",
	       SAMPLE_STRS-1);	
	printf(" -i N           : specify intercharacter skip. %s\n",
	       "(100 is default)\n");
	exit(0);
      }
  }

  Len = strlen(Str[Sno])/2;    /* ^_^;; */

  SkipDots  = (XDots*Skip)/100;
  WidthDots = XDots + SkipDots*(Len-1);
  XBytes    = (WidthDots + 7) / 8;
  if ((Buff = malloc(XBytes*YDots)) == NULL){
    fprintf(stderr, "malloc err\n");
    exit(0);
  } 
  bzero(Buff, XBytes*YDots);



  /**
   **  VF_Init()  --- INITIALIZE THE VFLIB 
   **    Its argument is a string (a path to vfontcap file).
   **    If null pointer is passed, VFlib uses default vfontcap file.
   **/
  if (VF_Init(Vfcap) >= 0)
    printf("Initializing VFlib: OK\n");
  else {
    printf("Initializing VFlib: FAILED\n");
    exit(1);
  }


  /**
   ** VF_OpenFont() --- OPENING A FONT ENTRY
   **   Its argument is a string (a name of font entry).
   **   A font entry descriptor is returned.
   **/
  if ((Fd = VF_OpenFont(Ent)) < 0){
    fprintf(stderr, "open error; %s\n", Ent);
    exit(-1);
  }
  printf("Opening font: OK\n");

  p = (unsigned char*) Str[Sno];
  i = 0;
  while (*p != '\0'){
    Ccode  = euc2jis(p);

    printf("Getting Bitmap for %04x ...", euc2jis(p));
    fflush(stdout);

    Pos = i*SkipDots;

    if (OutlineTest == 0){
      /**
       ** VF_GetBitmap()  --- GETTING BITMAP
       **   Get bitmap of character code CCODE (in JIS code).
       **/
      VF_GetBitmap(Ccode, Fd, XDots, YDots, XBytes, Pos%8, &Buff[Pos/8]);

    } else {  /* , OR */

      /**
       ** VF_GetOutline()  --- GETTING OUTLINE
       **   Get outline of character code CCODE (in JIS code).
       **/
      if ((vfdata = VF_GetOutline(Ccode, Fd)) == NULL){
	printf("Failed to get outline : %04x\n", Ccode);
      } else {
	/**
	 ** VF_DrawOutline()  --- GETTING BITMAP FROM OUTLINE
	 **/
	VF_DrawOutline(vfdata, Fd, XDots, YDots, XBytes, 
		       Pos%8, &Buff[Pos/8]);
	/**
	 ** VF_FreeOutline()  --- RELEASE OUTLINE DATA
	 **/
	VF_FreeOutline(vfdata, Fd);
      }

    }

    printf("done\n");
    p = p + 2;
    i++;

  }

  if (Tty == 1)
    Dump(Buff, WidthDots, YDots, XBytes);
  else 
    XDump(Buff, WidthDots, YDots, XBytes, WYMargin);

  /** 
   ** VF_CloseFont()  ---- CLOSING A FONT
   **   Close a font descriptor FD.
   **/
  VF_CloseFont(Fd);
  printf("Closing font: OK\n");

  /** 
   ** VF_Deinit()  ---- FINISH USING VFLIB
   **/
  VF_Deinit();

  return 0;
}

int
euc2jis(s)
  char  *s;
{
  int j1, j2;

  j1 = s[0];
  j2 = s[1];
  etoj(j1, j2);
  return (j1*0x100 + j2);
}


void
Dump(s, x, y, yyy)
  char  *s;
  int   x, y, yyy;
{
  register int          i, j;
  unsigned char         d;
  static unsigned char  
    mask[] = {0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01};

  printf("+");    
  for (i = 0; i < x; i++)
    printf("-"); 
  printf("+\n");
  for (j = 0; j < y; j++){
    printf("|"); 
    for (i = 0; i < x; i++){
      d = s[yyy*j + i/8];
      if (d & mask[i%8])
	printf("*");
      else
	printf(" ");
    }
    printf("|"); 
    printf("\n");
  }
  printf("+");    
  for (i = 0; i < x; i++)
    printf("-"); 
  printf("+\n");
}


void
XDump(s, x, y, yyy, mar)
  char  *s;
  int   x, y, yyy, mar;
{
  void  InitWin(), DeinitWin();
  int   ShowBitmap();

  InitWin(x, y+2*mar);
  ShowBitmap(s, x, y, yyy, mar);
  printf("Type RETURN key to exit\n");
  DeinitWin();
}




/*------------------------*/
#include <X11/Xlib.h>
#include <X11/Xutil.h>

Display               *Disp;
Window                Win;
GC                    Gc;
XGCValues             GcVal;
XSetWindowAttributes  Att;
unsigned int          WinX, WinY, WinBorder, WinDepth;
char                  *DisplayName; 
char                  *WindowName;


void
InitWin(x, y)
  int x, y;
{
  WindowName = "VFlib test";
  DisplayName = NULL;

  Disp = XOpenDisplay(DisplayName);
  Win  = XCreateSimpleWindow(Disp, RootWindow(Disp, 0), 
			    0, 0, x, y, 2,
			    BlackPixel(Disp, 0), WhitePixel(Disp, 0));
  Gc   = XCreateGC(Disp, Win, 0, 0);
  XStoreName(Disp, Win, WindowName);
  XMapWindow(Disp, Win);
  Att.override_redirect = True;
  Att.backing_store     = Always;
  XChangeWindowAttributes(Disp, Win, CWOverrideRedirect, &Att);
  XChangeWindowAttributes(Disp, Win, CWBackingStore, &Att);
}

void
DeinitWin()
{
  char	buf[BUFSIZ];

  XFlush(Disp);
  fgets(buf,BUFSIZ,stdin);
}

int
ShowBitmap(s, x, y, yyy, mar)
  char *s;
  int  x, y, yyy, mar;
{
  int     ix, iy, i;
  char    d, *xbitmap;
  Pixmap  pix;
  static unsigned char  
    tb1[8] = {0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01},
    tb2[8] = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80};
  unsigned long fg, bg;
  unsigned int depth;

  if ((xbitmap = malloc((y+2*mar)*((x+7)/8))) == NULL){
    fprintf(stderr, "Malloc err\n");
    return -1;
  }
  bzero(xbitmap, (y+2*mar)*((x+7)/8));

  for (iy = 0; iy < y; iy++)
    for (ix = 0; ix < (x+7)/8; ix++){
      d = 0;
      for (i = 0; i < 8; i++)
	if ((tb1[i] & s[ix+iy*yyy]) != 0)
	  d |= tb2[i];
      xbitmap[ix+(mar+iy)*((x+7)/8)] = d;
    }
  if (Frame == 1){
    for (i = 0; i < (x+7)/8; i++){
      xbitmap[i+(mar)*((x+7)/8)] = 0x03;
      xbitmap[i+(mar+y)*((x+7)/8)] = 0x03;
    }    
  }

  depth = DefaultDepth(Disp, DefaultScreen(Disp));
  fg    = BlackPixel(Disp, DefaultScreen(Disp));
  bg    = WhitePixel(Disp, DefaultScreen(Disp));
  XSetForeground(Disp, Gc, fg);
  XSetBackground(Disp, Gc, bg);
  pix = XCreatePixmapFromBitmapData(Disp, Win, xbitmap, x, y+2*mar, 
				    fg, bg, depth);
  XCopyArea(Disp, pix, Win, Gc, 0, 0, x, y+2*mar, 0, 0);
  return 0;
}

/*EOF*/

