<?php
/**
 * PHP version 5.
 *
 * Copyright (c) 2007-2010, Samurai Framework Project, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright notice,
 *       this list of conditions and the following disclaimer in the documentation
 *       and/or other materials provided with the distribution.
 *     * Neither the name of the Samurai Framework Project nor the names of its
 *       contributors may be used to endorse or promote products derived from this
 *       software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @package    Samurai
 * @copyright  2007-2010 Samurai Framework Project
 * @link       http://samurai-fw.org/
 * @license    http://www.opensource.org/licenses/bsd-license.php The BSD License
 * @version    SVN: $Id: String.class.php 3 2010-01-08 02:54:08Z hayabusa $
 */

/**
 * オブジェクト指向的文字列
 *
 * !!!!※!!!!
 * このクラスは遊び心から設置しているクラスです。
 * 仕様変更やサポートの中止など、報告なしに行われる可能性がありますので、業務等で使用するのは
 * 絶対におやめください。
 * 
 * @package    Samurai
 * @subpackage Etc.Oop
 * @copyright  2007-2010 Samurai Framework Project
 * @author     KIUCHI Satoshinosuke <scholar@hayabusa-lab.jp>
 * @license    http://www.opensource.org/licenses/bsd-license.php The BSD License
 */
class Etc_Oop_String extends Etc_Oop
{
    /**
     * 実体をセットする
     *
     * @access     public
     * @param      string  $entity
     */
    public function set($entity)
    {
        $this->_entity = (string)$entity;
    }


    /**
     * 文字列への変換
     *
     * @access     private
     * @return     string  文字列の実体
     */
    public function __toString()
    {
        return $this->_entity;
    }


    /**
     * PHP関数へのブリッジ
     *
     * @access     public
     * @param      string   $method   関数名
     * @param      array    $args     引数
     * @return     object   Etc_Oop
     */
    public function __call($method, $args = array())
    {
        if(function_exists($method)){
            array_unshift($args, $this->_entity);
            $result = call_user_func_array($method, $args);
            return $this->cast($result);
        } else {
            throw new Samurai_Exception('method not exists. -> ' . $method);
        }
    }


    /**
     * 文字列を連結する
     *
     * @access     public
     * @param      string   $string
     * @return     object   $this
     */
    public function cat($string)
    {
        $this->_entity .= (string)$string;
        return $this;
    }

    /**
     * 文字列の長さを返却する
     *
     * @access     public
     * @return     object   Etc_Oop_Integer
     */
    public function length()
    {
        return $this->cast(strlen($this->_entity));
    }

    /**
     * strtoupperのブリッジ
     *
     * @access     public
     * @return     object   Etc_Oop_String
     */
    public function toupper()
    {
        return $this->cast(strtoupper($this->_entity));
    }

    /**
     * strtoloweへのブリッジ
     *
     * @access     public
     * @return     object   Etc_Oop_String
     */
    public function tolower()
    {
        return $this->cast(strtolower($this->_entity));
    }

    /**
     * 文字列の変換
     *
     * @access     public
     * @param      string   $search    対象
     * @param      string   $replace   置換文字列
     * @param      int      $count     置換数
     * @return     object   Etc_Oop_String
     */
    public function replace($search, $replace, &$count)
    {
        return $this->cast(str_replace($search, $replace, $this->_entity, $count));
    }

    /**
     * 文字列をむちゃくちゃにして返却
     *
     * @access     public
     * @return     object   Etc_Oop_String
     */
    public function shuffle()
    {
        return $this->cast(str_shuffle($this->_entity));
    }

    /**
     * 文字列を分割する
     *
     * @access     public
     * @param      string   $pattern
     * @return     object   Etc_Oop_Array
     */
    public function split($pattern)
    {
        return $this->cast(split($pattern, $this->_entity));
    }
}

