<?
/**
 * Generator
 * 
 * Generatorのインターフェース的クラス。
 * 
 * @package    Samurai
 * @subpackage Generator
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
abstract class Generator
{
    public
        /** @var        object  Renderer4Generatorコンポーネント */
        $Renderer4Generator,
        /** @var        object  Utilityコンポーネント */
        $Utility;
    public
        /** @var        int     結果値(成功) */
        $RESULT_SUCCESS = 1,
        /** @var        int     結果値(既にある) */
        $RESULT_ALREADY = 2,
        /** @var        int     結果値(失敗) */
        $RESULT_FAILED = 3,
        /** @var        int     結果値(無視された) */
        $RESULT_IGNORE = 4;
    
    
    /**
     * Generateトリガーメソッド。
     * @access     public
     */
    abstract public function generate($filename, $skeleton, $params=array());
    
    
    /**
     * Generateの実処理担当。
     * fetch -> saveまでをこなす。
     * @access     protected
     * @param      string  $filename      出力ファイル名
     * @param      string  $skeleton      スケルトン名
     * @param      array   $params        Rendererに登録する変数
     * @param      boolean $is_resource   バイナリかどうか
     * @return     int     結果値
     */
    protected function _generate($filename, $skeleton, $params=array(), $is_resource=false)
    {
        //存在確認
        if(file_exists($filename)){
            return $this->RESULT_ALREADY;
        }
        //Renderer
        if(!$is_resource){
            $params = array_merge(Samurai_Config::getAll('generator.generator'), $params);
            foreach($params as $_key => $_val){
                $this->Renderer4Generator->assign($_key, $_val);
            }
            $source = $this->Renderer4Generator->render($skeleton);
        } else {
            $source = file_get_contents($skeleton);
        }
        //ディレクトリの補完
        $directory = dirname($filename);
        if(!file_exists($directory) || !is_dir($directory)){
            $this->Utility->fillupDirectory($directory, 0755);
        }
        //generate!!
        return file_put_contents($filename, $source) ? $this->RESULT_SUCCESS : $this->RESULT_FAILED ;
    }
    
    
    
    
    
    /**
     * スケルトンの取得。
     * @access     public
     * @param      string  $filename   スケルトン名
     * @return     string  スケルトン名
     */
    public function getSkeleton($filename)
    {
        $filename = sprintf('%s/%s', Samurai_Config::get('directory.skeleton'), $filename);
        //ローカル検索
        $skeleton = sprintf('%s/%s', Samurai_Config::get('generator.directory.samurai'), $filename);
        //グローバル検索
        if(!Samurai_Loader::isReadable($skeleton)){
            $skeleton = Samurai_Loader::getPath($filename);
        }
        return $skeleton;
    }
}
