<?
/**
 * Samurai_Container_Factory
 * 
 * DIContainerを管理するクラス。
 * 基本的に差し替えない(と言うよりも静的に参照するために、差し替えはほぼ不可能)。
 * 
 * @package    Samurai
 * @subpackage Component.Samurai
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Samurai_Container_Factory
{
    private
        /** @var        array   コンテナを格納 */
        static $_containers = array();
    
    
    /**
     * コンストラクタ。
     * @access     private
     */
    private function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * コンテナーを作成。
     * 既に作成されている場合は、既存のものを返却。
     * が、それを無視することも可能。
     * @access     public
     * @param      string  $name        登録名
     * @param      boolean $force_new   常にコンテナをnewするか(default=false)
     * @return     object  DIContainer
     */
    public static function create($name, $force_new=false)
    {
        if(!isset(self::$_containers[$name]) || $force_new){
            $container_class = Samurai_Config::get('container.class');
            if($container_class){
                Samurai_Loader::loadByClass($container_class);
                self::$_containers[$name] = new $container_class();
            } else {
                throw new Samurai_Exception('un inited Samurai.');
            }
        }
        return self::$_containers[$name];
    }
}
