<?
/**
 * Samurai_Controller
 * 
 * SamuraiFWを構成する、もっとも重要なコンポーネントのうちの一つ。
 * FWの動作の構成をつかさどるので、これを差し替える事によって、
 * FWの動作に変更を加えることも可能です。
 * 
 * @package    Samurai
 * @subpackage Component.Samurai
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Samurai_Controller
{
    public
        /** @var        object  Requestコンポーネント */
        $Request,
        /** @var        object  ActionChainコンポーネント */
        $ActionChain,
        /** @var        object  ConfigStackコンポーネント */
        $ConfigStack,
        /** @var        object  FilterChainコンポーネント */
        $FilterChain;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * FWの起動トリガー。
     * @access     public
     */
    public function execute()
    {
        //FrontFilterの作動
        $this->_frontFilter();
        //Actionの決定
        $this->Request->dispatchAction();
        //Actionの追加
        $this->ActionChain->clear();
        $this->ActionChain->add($this->Request->getParameter(Samurai_Config::get("action.request_key")));
        //Actionのスタックがある限り動作をつづける
        while($this->ActionChain->hasNext()){
            //ConfigStackの構築
            $this->ConfigStack->clear();
            $this->ConfigStack->execute();
            //FilterChainの構築＆実行
            $this->FilterChain->clear();
            $this->FilterChain->build($this->ConfigStack);
            $this->FilterChain->execute();
            //次のアクションへ
            $this->ActionChain->next();
        }
    }
    
    
    /**
     * FrontFilterの起動。
     * 通常のFilterChainでは、Actionが決定しないと動作しないために、別途手前で動作させる。
     * @access     private
     */
    private function _frontFilter()
    {
        $this->ConfigStack->clear();
        $this->ConfigStack->import(Samurai_Config::get('directory.config').'/samurai/frontfilter.yml', NULL);
        $this->FilterChain->clear();
        $this->FilterChain->build($this->ConfigStack);
        $this->FilterChain->execute();
    }
}
