<?
/**
 * Filter_Validate_Validator.abstract
 * 
 * Validatorの抽象クラス。
 * 
 * @package    Samurai
 * @subpackage Filter.Validate
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
abstract class Filter_Validate_Validator
{
    /**
     * Validator特有の機能を実装する。
     * @access     public
     * @param      array   $value    値
     * @param      array   $params   引数
     * @return     boolean 結果
     */
    abstract public function validate($value, $params=array());
    
    
    /**
     * エラーメッセージに動的な値を埋め込む。
     * @access     public
     */
    public function bindParams($message)
    {
        return $message;
    }
    
    
    /**
     * 文字列に値を埋め込む。
     * @access     protected
     * @param      string  &$message
     * @param      string  $placefolder
     * @param      mixed   $value
     */
    protected function _bindParam(&$message, $placefolder, $value)
    {
        $message = str_replace($placefolder, $value, $message);
    }
}
