<?
/**
 * Filter_Front_DeviceChanger
 * 
 * アクセス端末の切り替えをサポートするフロントフィルター
 * 端末情報は自前で揃える必要がある
 * 
 * @package    Samurai
 * @subpackage Filter.Front
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Front_DeviceChanger extends Samurai_Filter
{
    public
        /** @var        object  Device */
        $Device,
        /** @var        object  Request */
        $Request,
        /** @var        object  Session */
        $Cookie;
    
    
    /**
     * prefilter.
     * @override
     */
    public function _prefilter()
    {
        parent::_prefilter();
        if($this->_isEnable()){
            $device = $this->Request->get('samurai_device_changer');
            $c_device = $this->Cookie->get('SAMURAI.Filter.Front.DeviceChanger.device');
            if($device == 'reset'){
                $this->Cookie->del('SAMURAI.Filter.Front.DeviceChanger.device', '/');
            } elseif($device){
                $this->Cookie->set('SAMURAI.Filter.Front.DeviceChanger.device', $device, NULL, '/');
                $file = sprintf('%s/front/.device/%s', Samurai_Config::get('directory.filter'), $device);
                $this->_load($file);
            } elseif($c_device){
                $file = sprintf('%s/front/.device/%s', Samurai_Config::get('directory.filter'), $c_device);
                $this->_load($file);
            }
        }
    }
    
    
    /**
     * ファイル情報をロードする
     * @access     private
     */
    private function _load($file)
    {
        try {
            $info = Samurai_Yaml::load(Samurai_Loader::getPath($file));
            //httpフィールドのセット
            if(isset($info['http'])){
                foreach((array)$info['http'] as $_key => $_val){
                    $this->Request->setHeader($_key, $_val);
                }
            }
            //UIDセクションのアレンジ(同じ端末でアクセスした場合、UIDが被るので)
            if(isset($info['uid_section']) && $this->Request->hasHeader($info['uid_section'])){
                $random = $this->Cookie->get('SAMURAI.Filter.Front.DeviceChanger.seed', uniqid());
                $uid_sec = $info['uid_section'];
                $this->Request->setHeader($uid_sec, $this->Request->getHeader($uid_sec) . $random);
                $this->Cookie->set('SAMURAI.Filter.Front.DeviceChanger.seed', $random);
            }
        } catch(Samurai_Exception $E){}
    }
    
    
    
    
    
    /**
     * 切り替え可能かどうかのチェック
     * @access     private
     */
    private function _isEnable()
    {
        if($this->getAttribute('ip') && isset($_SERVER['REMOTE_ADDR'])){
            foreach((array)$this->getAttribute('ip') as $ip){
                $ip = str_replace('*', '.*?', $ip);
                if(preg_match('/'.$ip.'/', $_SERVER['REMOTE_ADDR'])){
                    return true;
                }
            }
        }
        return false;
    }
}
