<?
/**
 * Filter_Convert_Converter_Strim
 * 
 * SuperTrim.
 * Nativeに任せてもいいのだが、
 * 日本語環境下では全角の空白もtrimしたいことが多いと思うので。
 * 
 * @package    Samurai
 * @subpackage Filter.Convert
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Convert_Converter_Strim extends Filter_Convert_Converter
{
    /**
     * コンバート処理。
     * @access     public
     */
    public function convert($value)
    {
        return mb_ereg_replace('^[\s　]+|[\s　]$', '', $value);
    }
}
