<?
/**
 * Filter_ViewJson
 * 
 * Json表示を担当するFilter。
 * 
 * @package    Samurai
 * @subpackage Filter
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
**/
class Filter_ViewJson extends Samurai_Filter
{
    public
        /** @var        object  Requestコンポーネント */
        $Request,
        /** @var        object  Responseコンポーネント */
        $Response,
        /** @var        object  ActionChainコンポーネント */
        $ActionChain;
    
    
    /**
     * postfilter.
     * @override
     */
    protected function _postfilter()
    {
        parent::_postfilter();
        //Action結果の取得
        $result = $this->ActionChain->getCurrentActionResult();
        if(Samurai_Config::get('encoding.internal') != 'UTF-8'){
            mb_convert_variables('UTF-8', Samurai_Config::get('encoding.internal'), $result);
        }
        $result = json_encode($result);
        //JSONP(JSON with Padding)コールバックの指定がある場合
        if($this->getAttribute('jsonp') && $this->Request->getParameter($this->getAttribute('jsonp'))){
            $result = $this->Request->getParameter($this->getAttribute('jsonp')).'('.$result.');';
        //JSONF(JSON with Frash)
        } elseif($this->getAttribute('jsonf') && $this->Request->getParameter($this->getAttribute('jsonf'))){
            $result = $this->Request->getParameter($this->getAttribute('jsonf')).'='.$result;
        //JSONI(JSON with Iframe)コールバックの指定がある場合
        } elseif($this->getAttribute('jsoni') && $this->Request->getParameter($this->getAttribute('jsoni'))){
            $function = $this->Request->getParameter($this->getAttribute('jsoni'));
            //$view = "parent.".$Request->getParameter($this->getAttribute("jsoni"))."(".$view.");";
            $result = join("\r\n", array(
                "<SCRIPT type=\"text/javascript\">",
                "    var result = {$view};",
                "    alert(typeof(parent.document));",
                //"    parent.{$function}(result);",
                "</SCRIPT>",
            ));
        } else {
            $this->Response->setHeader('x-json', $result);
        }
        $Body = $this->Response->setBody($result);
        if(is_object($Body) && !$this->Response->hasHeader('content-type')){
            //$Body->setHeader('content-type', sprintf('application/json; charset=%s', Samurai_Config::get('encoding.output')));
            //$Body->setHeader('content-type', sprintf('text/json; charset=%s', Samurai_Config::get('encoding.output')));
        }
        $this->Response->execute();
    }
}
