<?
/**
 * diconファイルの読み込みを行うFilter。
 * 現在の階層までのglobalなdiconファイルと現アクション専用のdiconファイルをオートに読み込む。
 * その他指定のdiconファイルも読み込み可能。
 * 
 * @package    Samurai
 * @subpackage Filter
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_DIContainer extends Samurai_Filter
{
    private
        /** @var        boolean 自動読み込み */
        $_autoload = true,
        /** @var        array   diconファイル */
        $_dicon_files = array();
    public
        /** @var        object  Containerコンポーネント */
        $Container,
        /** @var        object  ActionChainコンポーネント */
        $ActionChain;
    
    
    /**
     * prefilter.
     * @override
     */
    protected function _prefilter(){
        parent::_prefilter();
        //初期化
        $this->_init();
        //オートロード
        if($this->_autoload){
            $this->_loadActionDicons();
        }
        //指定のdiconファイル
        $this->_loadDicons();
    }
    
    
    /**
     * diconファイルの読み込み。
     * @access     public
     * @param      string  $dicon_file
     */
    public function import($dicon_file)
    {
        $defines = Samurai_Yaml::load($dicon_file);
        foreach($defines as $alias => $define){
            $this->Container->registerComponent($alias, new Samurai_Container_Def($define));
        }
    }
    
    
    
    
    
    /**
     * Actionディレクトリ配下の、
     * 現在のActionまでのdiconファイルをロードする。
     * @access     private
     */
    private function _loadActionDicons()
    {
        $action = $this->ActionChain->getCurrentActionName();
        $path_list = explode('_', $action);
        $current_path = Samurai_Config::get('directory.action');
        foreach($path_list as $i => $path){
            //globalファイル
            $this->import(sprintf('%s%s%s', $current_path, DS, Samurai_Config::get('action.dicon_file')));
            //localファイル
            if($i == count($path_list)-1){
                $this->import(sprintf('%s%s%s.dicon', $current_path, DS, $path));
            }
            $current_path = sprintf('%s%s%s', $current_path, DS, $path);
        }
    }
    
    
    /**
     * 指定のdiconファイルをロードする。
     * @access     private
     */
    private function _loadDicons()
    {
        foreach($this->_dicon_files as $dicon_file){
            $this->import($dicon_file);
        }
    }
    
    
    
    
    
    /**
     * 初期化。
     * @access     private
     */
    private function _init()
    {
        //オートロード
        $autoload = $this->getAttribute('autoload');
        if($autoload !== NULL && !$autoload){
            $this->_autoload = false;
        }
        //指定のdicon
        $this->_dicon_files = (array)$this->getAttribute('dicon');
        //コンテナ
        $this->Container = Samurai::getContainer();
    }
}
