<?
/**
 * Filter_Convert
 * 
 * Convert処理を行うFilter。
 * 
 * @package    Samurai
 * @subpackage Filter
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Convert extends Samurai_Filter
{
    public
        /** @var        object  ConverterManagerコンポーネント */
        $Manager,
        /** @var        object  Requestコンポーネント */
        $Request;
    private
        /** @var        array   パイプで分解したものを順番に格納 */
        $_stacks = array();
    
    
    /**
     * prefilter.
     * @override
     */
    protected function _prefilter()
    {
        parent::_prefilter();
        //マネージャーの生成
        $this->_createManager();
        //スタックの積み上げ
        $this->_createStacks();
        //スタックの解消
        $this->_dissolveStacks();
    }
    
    
    /**
     * 積み上げられたスタックを解消していく。
     * @access     private
     */
    private function _dissolveStacks()
    {
        foreach($this->_stacks as $_key => $_val){
            //キーの分解
            $keys = $this->_resolveKeys($_key);
            //パイプで分解する
            $pipes = $this->_resolve($_val, '|');
            foreach($pipes as $pipe_value){
                $force_grouping = false;
                $redirects = $this->_resolve($pipe_value, '>');
                $converter = array_shift($redirects);
                if(preg_match('/^@(.*)$/', $converter, $matches)){
                    $force_grouping = true;
                    $converter = $matches[1];
                }
                $Converter = $this->Manager->getConverter($converter);
                //リダイレクトの指定がない場合
                if(!$redirects){
                    foreach($keys as $key){
                        $value = $this->Request->getParameter($key);
                        $value = $Converter->convert($value);
                        $this->Request->setParameter($key, $value);
                    }
                }
                //リダイレクトの指定がある場合
                elseif(count($keys) > 1 || $force_grouping){
                    $value = array();
                    foreach($keys as $key){
                        $value[$key] = $this->Request->getParameter($key);
                    }
                    $value = $Converter->convert($value);
                } elseif(count($keys) == 1){
                    $value = $this->Request->getParameter($keys[0]);
                    $value = $Converter->convert($value);
                }
                //リダイレクト
                foreach($redirects as $redirect){
                    $this->Request->setParameter($redirect, $value);
                    $keys = array($redirect);
                }
            }
        }
    }
    
    
    
    
    
    /**
     * キーを分解する。
     * @access     private
     * @param      string  $key   キー文字列
     * @return     array   分解されたキー
     */
    private function _resolveKeys($key)
    {
        $keys = $this->_resolve($key, ',');
        if(in_array('*', $keys)){
            $keys = array_merge($keys, array_keys($this->Request->getParameters()));
            unset($keys[array_search('*', $keys)]);
        }
        $keys = array_unique($keys);
        return $keys;
    }
    
    
    /**
     * 文字列を指定の文字列で分解する。
     * @access     private
     * @param      string  $string      対象文字列
     * @param      string  $delimiter   区切り文字
     * @return     array   分解されたもの
     */
    private function _resolve($string, $delimiter)
    {
        $delimiter = preg_quote($delimiter);
        return preg_split("/\s*{$delimiter}\s*/", trim($string));
    }
    
    
    
    
    
    /**
     * スタックの積み上げ。
     * @access     private
     */
    private function _createStacks()
    {
        foreach((array)$this->getAttributes() as $_key => $_val){
            $this->_stacks[$_key] = $_val;
        }
    }
    
    
    /**
     * ConverterManagerの生成。
     * @access     private
     */
    private function _createManager()
    {
        Samurai_Loader::loadByClass('Filter_Convert_Manager');
        $this->Manager = new Filter_Convert_Manager();
    }
}
