<?
/**
 * Filter_Action
 * 
 * Actionの実行を準備および実行を行うFilter。
 * 
 * @package    Samurai
 * @subpackage Filter
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Action extends Samurai_Filter
{
    public
        /** @var        object  Requestコンポーネント */
        $Request,
        /** @var        object  ActionChainコンポーネント */
        $ActionChain;
    
    
    /**
     * prefilter.
     * オートインジェクションや、エラーが発生していた場合の対処など。
     * @override
     */
    protected function _prefilter()
    {
        parent::_prefilter();
        //カレントのActionを取得
        $Action = $this->ActionChain->getCurrentAction();
        //Actionにオートインジェクション
        $Container = Samurai::getContainer();
        if(Samurai_Config::get('enable.request_injection')){
            $Container->injectAttributes($Action, $this->Request->getParameters());
        }
        $Container->injectDependency($Action, $this->_attributes2Def($this->getAttributes()));
        foreach($this->getAttributes() as $_key => $_val){
            if(is_string($_val) && preg_match('/^\$(.*+)/', $_val, $matches)){
                $Container->injectAttributes($Action, array($_key=>$Container->getComponent($matches[1])));
            }
        }
        $Action->ErrorList = $this->ActionChain->getCurrentErrorList();
        //Actionの実行
        $error_type = $this->ActionChain->getCurrentErrorList()->getType();
        $result = $this->ActionChain->executeAction($Action, $error_type);
        $this->ActionChain->setCurrentActionResult($result);
    }
    
    
    /**
     * Actionの設定内容から、Component_Defを生成。
     * @access     private
     * @param      array   $attributes   属性
     */
    private function _attributes2Def(array $attributes=array())
    {
        $define = array();
        foreach($attributes as $_key => $_val){
            switch($_key){
                case 'rule':
                case 'setter':
                case 'allow':
                case 'deny':
                    $define[$_key] = $_val;
                    break;
            }
        }
        return new Samurai_Container_Def($define);
    }
}
