<?
/**
 * Etc_Oop_String
 * 
 * [[機能説明]]
 * 
 * @package    Samurai
 * @subpackage Etc.Oop
 * @copyright  BEFOOL,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Etc_Oop_String extends Etc_Oop
{
    /**
     * 実体をセットする。
     * @access     public
     * @param      string  $entity
     */
    public function set($entity)
    {
        $this->_entity = (string)$entity;
    }
    
    
    /**
     * 文字列への変換。
     * @access     private
     * @return     string  文字列の実体
     */
    public function __toString()
    {
        return $this->_entity;
    }
    
    
    
    
    
    /**
     * PHP関数へのブリッジ。
     * @access     public
     */
    public function __call($method, $args=array())
    {
        if(function_exists($method)){
            array_unshift($args, $this->_entity);
            $result = call_user_func_array($method, $args);
            return $this->cast($result);
        } else {
            throw new Samurai_Exception('method not exists. -> '.$method);
        }
    }
    
    
    /**
     * __callでは対応しきれないものや、
     * str_*のように文字列にかける事を明言しているような場合、それを省略できるように。
     * @access     public
     */
    public function cat($string)
    {
        $this->_entity .= (string)$string;
        return $this;
    }
    public function length()
    {
        return $this->cast(strlen($this->_entity));
    }
    public function toupper()
    {
        return $this->cast(strtoupper($this->_entity));
    }
    public function tolower()
    {
        return $this->cast(strtolower($this->_entity));
    }
    public function replace($search, $replace, &$count)
    {
        return $this->cast(str_replace($search, $replace, $this->_entity, $count));
    }
    public function shuffle()
    {
        return $this->cast(str_shuffle($this->_entity));
    }
    public function split($pattern)
    {
        return $this->cast(split($pattern, $this->_entity));
    }
}
