<?
/**
 * Etc_Mail_Address
 * 
 * Etc_Mailでメールアドレスを体現。
 * 
 * @package    Samurai
 * @subpackage Etc.Mail
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Etc_Mail_Address
{
    public
        /** @var        string  メールアドレス */
        $mail = '',
        /** @var        string  名前 */
        $name = '';
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * 文字列に変換。
     * @access     public
     * @return     string  整形されたメールアドレス文字列
     */
    public function toString()
    {
        if(!$this->name){
            return $this->mail;
        } else {
            return sprintf('%s <%s>', $this->name, $this->mail);
        }
    }
    
    
    /**
     * encode_mimeheaderされた文字列
     * @access     public
     */
    public function encodeMimeheader($charset=NULL)
    {
        if(!$this->name){
            return $this->mail;
        } else {
            return sprintf('%s <%s>', $charset ?
                                        mb_encode_mimeheader($this->name, $charset) : mb_encode_mimeheader($this->name), $this->mail);
        }
    }
}
