<?
/**
 * Etc_File_Scanner_Condition
 * 
 * ファイルの走査の条件クラス。
 * scanする際の条件に用いられる。
 * 
 * @package    Samurai
 * @subpackage Etc.File.Scanner
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Etc_File_Scanner_Condition
{
    public
        $type = '',
        $value = '',
        $negative = false,
        $target = 'basename',
        $reflexive = false;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * 正規表現の条件を設定する
     * @access     public
     * @param      string   $regexp   正規表現
     */
    public function setRegexp($regexp)
    {
        $this->type = 'regexp';
        $this->value = $regexp;
    }
    
    
    /**
     * 拡張子が一致するかどうか
     * @todo
     */
    public function setExtension($extension)
    {
        if(is_array($extension)) $extension = join('|', $extension);
        $this->setRegexp('/\.('.$extension.')$/');
    }
    
    
    
    
    
    /**
     * 比較する
     * @access     public
     * @param      object   $File   Etc_File_Scanner_Entity
     */
    public function match(Etc_File_Scanner_Entity $File)
    {
        $target = $File->{$this->target};
        switch($this->type){
            case 'regexp':
                $result = preg_match($this->value, $target, $File->matches);
                break;
            default:
                $result = true;
                break;
        }
        return $this->negative ? !$result : $result;
    }
}
