<?
/**
 * Etc_File_Image_Converter_Worker
 * 
 * 画像のコンバートをサポートするコンポーネント
 * そのWorker抽象クラス
 * 
 * @package    Samurai
 * @subpackage Etc.File.Image.Converter
 * @copyright  BEFOOL,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
abstract class Etc_File_Image_Converter_Worker
{
    protected
        /** @var        object  Etc_File_Image_Converter */
        $Converter;
    
    
    /**
     * コンストラクタ
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * コンバートトリガー
     * 実処理は_convertメソッドが担当
     * @access     public
     * @param      object  $Converter   Etc_File_Image_Converter
     */
    public function convert(Etc_File_Image_Converter $Converter)
    {
        $this->Converter = $Converter;
        return $this->_convert();
    }
    
    
    /**
     * コンバート実処理
     * それぞれのワーカーで実装する
     * @access     protected
     */
    abstract protected function _convert();
}
