<?
/**
 * Etc_Device_Base
 * 
 * デバイスクラスの基本。
 * すべての拡張デバイスクラスは、このクラスを継承している。
 * 
 * @package    Etc
 * @subpackage Device
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Etc_Device_Base
{
    public
        /** @var        string  user_agent */
        $user_agent = '',
        /** @var        array   user_agentを分解したもの */
        $user_agents = array(),
        /** @var        string  クライアント種類 */
        $client = 'pc',
        /** @var        string  ブラウザ名 */
        $browser_name = '',
        /** @var        string  ブラウザタイプ(xhtml|html) */
        $browser_type = 'xhtml',
        /** @var        string  画面サイズ(xga|svga|qvga|qqvga) */
        $display_type = 'svga',
        /** @var        int     画面カラー数 */
        $display_color = 16777216,
        /** @var        int     画面横幅 */
        $display_x = 800,
        /** @var        int     画面縦幅 */
        $display_y = 600,
        /** @var        string  IPアドレス */
        $ip = '',
        /** @var        string  個人特定文字列 */
        $serial = '';
    
    
    /**
     * コンストラクタ。
     * @access    public
     * @param     string  $user_agent   user_agent
     */
    public function __construct($user_agent)
    {
        $this->user_agent = $user_agent;
        $this->user_agents = preg_split('/[\s\/\-\(\);]/', $this->user_agent);
        switch(true){
            case !$this->user_agent && php_sapi_name()=='cli':
                $this->client = 'cli';
                break;
            case $this->user_agents[0]=='DoCoMo':
                $this->client = 'imode';
                break;
            case $this->user_agents[0]=='KDDI' || $this->user_agents[0]=='UP.Browser':
                $this->client = 'ezweb';
                break;
            case $this->user_agents[0]=='SoftBank' || $this->user_agents[0]=='Vodafone'
                    || $this->user_agents[0]=='J-PHONE' || $this->user_agents[0]=='Semulator':
                $this->client = 'softbank';
                break;
            case isset($this->user_agents[2]) && $this->user_agents[2]=='WILLCOM':
                $this->client = 'willcom';
                break;
        }
        $this->ip = $this->getIP();
    }
    
    
    /**
     * ユーザーエージェントの取得。
     * @access     public
     * @return     string  user_agent
     */
    public function getUserAgent()
    {
        return $this->user_agent;
    }
    
    
    /**
     * clientの取得。
     * @access     public
     * @return     string  client
     */
    public function getClient()
    {
        return $this->client;
    }
    
    
    /**
     * ブラウザ名の取得。
     * @access     public
     * @return     string  browser_name
     */
    public function getBrowserName()
    {
        return $this->browser_name;
    }
    
    
    /**
     * browser_typeの取得。
     * html
     * @access     public
     * @return     string  browser_type
     */
    public function getBrowserType()
    {
        return $this->browser_type;
    }
    
    
    /**
     * 画面サイズの取得。
     * @access     public
     * @return     string  display_type
     */
    public function getDisplayType()
    {
        return $this->display_type;
    }
    
    
    /**
     * 画面カラー数の取得。
     * @access     public
     * @return     string  display_color
     */
    public function getDisplayColor()
    {
        return $this->display_color;
    }
    
    
    /**
     * 画面横幅の取得。
     * @access     public
     * @return     int     display_x
     */
    public function getDisplayX()
    {
        return $this->display_x;
    }
    /**
     * 画面縦幅の取得。
     * @access     public
     * @return     int     display_y
     */
    public function getDisplayY()
    {
        return $this->display_y;
    }
    
    
    /**
     * IPアドレスを取得する。
     * @access     public
     * @return     string  IPアドレス
     */
    public function getIP()
    {
        if($this->ip != ''){
            return $this->ip;
        } elseif(isset($_SERVER['REMOTE_ADDR'])){
            return $_SERVER['REMOTE_ADDR'];
        }
        return '';
    }
    
    
    /**
     * 個人特定IDの取得。
     * IPアドレスや、UID等。
     * @access     public
     * @return     string  個人特定ID
     */
    public function getSerial()
    {
        return $this->serial;
    }
    
    
    
    
    
    /**
     * 携帯かどうかの判断。
     * @access     public
     * @return     boolean 携帯かどうか
     */
    public function isMobile()
    {
        $mobiles = array('imode', 'ezweb', 'softbank', 'emobile', 'willcom');
        return in_array($this->client, $mobiles);
    }
    
    
    /**
     * cliかどうか。
     * @access     public
     * @return     boolean cliかどうか
     */
    public function isCli()
    {
        return $this->client === 'cli';
    }
}
