<?
/**
 * Etc_Oop
 * 
 * オブジェクト思考的な記述を出来るようにするツール。
 * 
 * @package    Samurai
 * @subpackage Etc.Oop
 * @copyright  BEFOOL,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Etc_Oop
{
    protected
        /** @var        null  実体 */
        $_entity = NULL;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct($entity=NULL)
    {
        $this->set($entity);
    }
    
    
    /**
     * 実体をセットする。
     * @access     public
     * @param      int     $entity
     */
    public function set($entity)
    {
        $this->_entity = $entity;
    }
    
    
    /**
     * 実体をそのまま返却する。
     * @access     public
     */
    public function raw()
    {
        return $this->_entity;
    }
    
    
    /**
     * 文字列への変換。
     * @access     private
     * @return     string  文字列の実体
     */
    public function __toString()
    {
        return (string)$this->_entity;
    }
    
    
    /**
     * 型を変換する。
     * @access     public
     */
    public function cast($value)
    {
        switch(true){
            case is_string($value):
                $value = new Etc_Oop_String($value);
                break;
            case is_integer($value):
            case is_float($value):
                $value = new Etc_Oop_Integer($value);
                break;
            case is_array($value):
                $value = new Etc_Oop_Array($value);
                break;
        }
        return $value;
    }
    
    
    
    
    
    /**
     * PHP関数へのブリッジ。
     * @access     public
     */
    public function __call($method, $args=array())
    {
        if(function_exists($method)){
            array_unshift($args, $this->_entity);
            $result = call_user_func_array($method, $args);
            return $this->cast($result);
        } else {
            throw new Samurai_Exception('method not exists. -> '.$method);
        }
    }
    
    
    /**
     * __callでは対応しきれないものや、
     * str_*のように文字列にかける事を明言しているような場合、それを省略できるように。
     * @access     public
     */
}
