<?
/**
 * Smarty/plugins/modifier.compare.php
 * 
 * 参考演算私的なプラグイン。
 * <code>
 *     // $value = 'foo';
 *     {$value|compare:'foo':'true':'false'}    // 'true'
 *     {$value|compare:'bar':'true':'false'}    // 'false'
 * </code>
 * 
 * @package    Smarty
 * @subpackage modifier
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 * @param      mixed   $value1   比較対象
 * @param      mixed   $value2   期待値
 * @param      mixed   $true     等の場合
 * @param      mixed   $false    不等の場合
 * @return     mixed   $value1と$value2を比較したさいの結果に応じて$trueの値か$falseの値
 */
function smarty_modifier_compare($value1, $value2, $true=NULL, $false=NULL)
{
    return $value1 === $value2 ? $true : $false ;
}
