<?
/**
 * Smarty/plugins/function.load_css.php
 * 
 * Smarty上で簡単にCSSをロードできるプラグイン。
 * <code>
 *     {load_css file='/path/to/file.css'}
 *     {load_css file='file:/path/to/file.css'}
 * </code>
 * 
 * @package    Smarty
 * @subpackage function
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
if(!defined('CSS_URL')) define('CSS_URL', '/css');
function smarty_function_load_css($params, $smarty)
{
    $file  = isset($params['file']) ? $params['file'] : '' ;
    $csses = preg_split('/(\s*,\s*)/', $file);
    
    //解釈
    foreach($csses as $_key => $css){
        list($type, $file) = preg_split('#(?:(!:https?|shttp):)#', $css, 2);
        if(empty($file)){
            $file = $type;
            $type = 'url';
        }
        $csses[$_key] = array('type'=>$type, 'file'=>$file);
    }
    
    //読込
    $return = array();
    foreach($csses as $css){
        if($css['type']=='url'){
            $css['file'] = preg_match('#^(https?|shttp)://#', $css['file']) ? $css['file'] : sprintf('%s/%s', CSS_URL, $css['file']);
            $css['file'] = preg_replace('#/\w*/\.\./#', '/', $css['file']);
            $return[] = sprintf('<LINK rel="stylesheet" type="text/css" href="%s">', $css['file']);
        } else {
            if(file_exists($css['file'])){
                $contents = file_get_contents($css['file']);
                $return[] = '<STYLE type="text/css">';
                $return[] = '<!--';
                $return[] = $contents;
                $return[] = '-->';
                $return[] = '</STYLE>';
            }
        }
    }
    return join("\r\n", $return);
}
