<?
/**
 * ActiveGatewayUtils
 * 
 * ActiveGatewayの雑務クラス。
 * 
 * @package    ActiveGateway
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class ActiveGatewayUtils
{
    /**
     * コンストラクタ。
     * @access     private
     */
    private function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * YAMLのロードを行う。
     * @access     public
     * @return     array   読み込み結果
     */
    public static function loadYaml($yaml_file)
    {
        //Samurai_Yamlの検索
        if(class_exists('Samurai_Yaml')){
            $config = Samurai_Yaml::load($yaml_file);
        } elseif(file_exists($yaml_file)){
            //syckエクステンションの検索
            if(function_exists('syck_load')){
                $config = syck_load(file_get_contents($yaml_file));
            }
            //Spycの検索
            else {
                include_once('Spyc/spyc.php');
                $config = Spyc::YAMLLoad($yaml_file);
            }
        } else {
            $config = array();
        }
        return $config;
    }
    
    
    /**
     * オブジェクトを配列に変換する。
     * @access     public
     * @param      object  $object      対象インスタンス
     * @param      boolean $reflexive   再帰的に適用するかどうか
     * @return     array   配列に変換されたもの
     */
    public static function object2Array($object, $reflexive=false)
    {
        $result = array();
        if(is_object($object)){
            if(method_exists($object, 'toArray')){
                $result = $object->toArray();
            } else {
                foreach(get_object_vars($object) as $_key => $_val){
                    if(!preg_match('/^_/', $_key)){
                        if(is_object($_val) && $reflexive){
                            $_val = self::object2Array($_val, $reflexive);
                        }
                        $result[$_key] = $_val;
                    }
                }
            }
        } elseif(is_array($object)){
            foreach($object as $_key => $_val){
                if(is_object($_val) && $reflexive){
                    $_val = self::object2Array($_val, $reflexive);
                }
                $result[$_key] = $_val;
            }
        } else {
            return $object;
        }
        return $result;
    }
}
